@extends('layouts.app')

@section('title', 'تفاصيل جدول الصيانة الدورية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل جدول الصيانة الدورية #{{ $schedule->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance-schedules.edit', $schedule->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('elevator-maintenance-schedules.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات أساسية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الجدول</th>
                                            <td>{{ $schedule->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>المصعد</th>
                                            <td>
                                                <a href="{{ route('elevators.show', $schedule->elevator_id) }}">
                                                    {{ $schedule->elevator->model ?? 'غير محدد' }} - {{ $schedule->elevator->serial_number ?? 'غير محدد' }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نوع الصيانة</th>
                                            <td>{{ $schedule->maintenance_type }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $schedule->description }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفني المسؤول</th>
                                            <td>{{ $schedule->technician->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المدة المقدرة</th>
                                            <td>{{ $schedule->estimated_duration }} دقيقة</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($schedule->status == 'active')
                                                    <span class="badge badge-success">نشط</span>
                                                @elseif($schedule->status == 'inactive')
                                                    <span class="badge badge-warning">غير نشط</span>
                                                @elseif($schedule->status == 'completed')
                                                    <span class="badge badge-info">مكتمل</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $schedule->creator->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $schedule->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الجدولة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">التكرار</th>
                                            <td>
                                                @if($schedule->frequency == 'daily')
                                                    <span class="badge badge-info">يومي</span>
                                                @elseif($schedule->frequency == 'weekly')
                                                    <span class="badge badge-primary">أسبوعي</span>
                                                @elseif($schedule->frequency == 'monthly')
                                                    <span class="badge badge-success">شهري</span>
                                                @elseif($schedule->frequency == 'quarterly')
                                                    <span class="badge badge-warning">ربع سنوي</span>
                                                @elseif($schedule->frequency == 'semi_annual')
                                                    <span class="badge badge-danger">نصف سنوي</span>
                                                @elseif($schedule->frequency == 'annual')
                                                    <span class="badge badge-dark">سنوي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        @if($schedule->day_of_week !== null)
                                        <tr>
                                            <th>يوم الأسبوع</th>
                                            <td>
                                                @php
                                                    $days = ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'];
                                                @endphp
                                                {{ $days[$schedule->day_of_week] }}
                                            </td>
                                        </tr>
                                        @endif
                                        @if($schedule->day_of_month !== null)
                                        <tr>
                                            <th>يوم الشهر</th>
                                            <td>{{ $schedule->day_of_month }}</td>
                                        </tr>
                                        @endif
                                        @if($schedule->month_of_year !== null)
                                        <tr>
                                            <th>شهر السنة</th>
                                            <td>
                                                @php
                                                    $months = ['يناير', 'فبراير', 'مارس', 'أبريل', 'مايو', 'يونيو', 'يوليو', 'أغسطس', 'سبتمبر', 'أكتوبر', 'نوفمبر', 'ديسمبر'];
                                                @endphp
                                                {{ $months[$schedule->month_of_year - 1] }}
                                            </td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>تاريخ البدء</th>
                                            <td>{{ $schedule->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $schedule->end_date ? $schedule->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تشغيل</th>
                                            <td>{{ $schedule->last_run_date ? $schedule->last_run_date->format('Y-m-d') : 'لم يتم التشغيل بعد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>التشغيل التالي</th>
                                            <td>{{ $schedule->next_run_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $schedule->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">عمليات الصيانة المرتبطة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>تاريخ الجدولة</th>
                                                    <th>تاريخ الإكمال</th>
                                                    <th>الفني المسؤول</th>
                                                    <th>الحالة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($schedule->maintenanceOperations as $maintenance)
                                                <tr>
                                                    <td>{{ $maintenance->id }}</td>
                                                    <td>{{ $maintenance->scheduled_date->format('Y-m-d H:i') }}</td>
                                                    <td>{{ $maintenance->completion_date ? $maintenance->completion_date->format('Y-m-d H:i') : 'غير مكتمل' }}</td>
                                                    <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                                    <td>
                                                        @if($maintenance->status == 'scheduled')
                                                            <span class="badge badge-info">مجدولة</span>
                                                        @elseif($maintenance->status == 'in_progress')
                                                            <span class="badge badge-warning">قيد التنفيذ</span>
                                                        @elseif($maintenance->status == 'completed')
                                                            <span class="badge badge-success">مكتملة</span>
                                                        @elseif($maintenance->status == 'cancelled')
                                                            <span class="badge badge-danger">ملغاة</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-info btn-sm">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="6" class="text-center">لا توجد عمليات صيانة مرتبطة بهذا الجدول</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection