@extends('layouts.app')

@section('title', 'جداول الصيانة الدورية للمصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">جداول الصيانة الدورية للمصاعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance-schedules.generate') }}" class="btn btn-success btn-sm mx-1">
                            <i class="fas fa-sync"></i> توليد عمليات الصيانة
                        </a>
                        <a href="{{ route('elevator-maintenance-schedules.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة جدول صيانة جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المصعد</th>
                                    <th>نوع الصيانة</th>
                                    <th>التكرار</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ التشغيل التالي</th>
                                    <th>الفني المسؤول</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($schedules as $schedule)
                                <tr>
                                    <td>{{ $schedule->id }}</td>
                                    <td>{{ $schedule->elevator->model ?? 'غير محدد' }} - {{ $schedule->elevator->serial_number ?? 'غير محدد' }}</td>
                                    <td>{{ $schedule->maintenance_type }}</td>
                                    <td>
                                        @if($schedule->frequency == 'daily')
                                            <span class="badge badge-info">يومي</span>
                                        @elseif($schedule->frequency == 'weekly')
                                            <span class="badge badge-primary">أسبوعي</span>
                                        @elseif($schedule->frequency == 'monthly')
                                            <span class="badge badge-success">شهري</span>
                                        @elseif($schedule->frequency == 'quarterly')
                                            <span class="badge badge-warning">ربع سنوي</span>
                                        @elseif($schedule->frequency == 'semi_annual')
                                            <span class="badge badge-danger">نصف سنوي</span>
                                        @elseif($schedule->frequency == 'annual')
                                            <span class="badge badge-dark">سنوي</span>
                                        @endif
                                    </td>
                                    <td>{{ $schedule->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $schedule->next_run_date->format('Y-m-d') }}</td>
                                    <td>{{ $schedule->technician->name ?? 'غير محدد' }}</td>
                                    <td>
                                        @if($schedule->status == 'active')
                                            <span class="badge badge-success">نشط</span>
                                        @elseif($schedule->status == 'inactive')
                                            <span class="badge badge-warning">غير نشط</span>
                                        @elseif($schedule->status == 'completed')
                                            <span class="badge badge-info">مكتمل</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('elevator-maintenance-schedules.show', $schedule->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('elevator-maintenance-schedules.edit', $schedule->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('elevator-maintenance-schedules.destroy', $schedule->id) }}" method="POST" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف جدول الصيانة الدورية؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد جداول صيانة دورية</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer clearfix">
                    {{ $schedules->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection