@extends('layouts.app')

@section('title', 'إضافة جدول صيانة دورية جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة جدول صيانة دورية جديد</h3>
                </div>
                <form action="{{ route('elevator-maintenance-schedules.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">اختر المصعد</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} - {{ $elevator->serial_number }} ({{ $elevator->location->name ?? 'غير محدد' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_type">نوع الصيانة</label>
                                    <input type="text" name="maintenance_type" id="maintenance_type" class="form-control @error('maintenance_type') is-invalid @enderror" value="{{ old('maintenance_type') }}" required>
                                    @error('maintenance_type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">وصف الصيانة</label>
                            <textarea name="description" id="description" rows="3" class="form-control @error('description') is-invalid @enderror" required>{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="frequency">تكرار الصيانة</label>
                                    <select name="frequency" id="frequency" class="form-control @error('frequency') is-invalid @enderror" required>
                                        <option value="">اختر التكرار</option>
                                        <option value="daily" {{ old('frequency') == 'daily' ? 'selected' : '' }}>يومي</option>
                                        <option value="weekly" {{ old('frequency') == 'weekly' ? 'selected' : '' }}>أسبوعي</option>
                                        <option value="monthly" {{ old('frequency') == 'monthly' ? 'selected' : '' }}>شهري</option>
                                        <option value="quarterly" {{ old('frequency') == 'quarterly' ? 'selected' : '' }}>ربع سنوي</option>
                                        <option value="semi_annual" {{ old('frequency') == 'semi_annual' ? 'selected' : '' }}>نصف سنوي</option>
                                        <option value="annual" {{ old('frequency') == 'annual' ? 'selected' : '' }}>سنوي</option>
                                    </select>
                                    @error('frequency')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 frequency-options" id="weekly-options" style="display: none;">
                                <div class="form-group">
                                    <label for="day_of_week">يوم الأسبوع</label>
                                    <select name="day_of_week" id="day_of_week" class="form-control @error('day_of_week') is-invalid @enderror">
                                        <option value="0" {{ old('day_of_week') == '0' ? 'selected' : '' }}>الأحد</option>
                                        <option value="1" {{ old('day_of_week') == '1' ? 'selected' : '' }}>الإثنين</option>
                                        <option value="2" {{ old('day_of_week') == '2' ? 'selected' : '' }}>الثلاثاء</option>
                                        <option value="3" {{ old('day_of_week') == '3' ? 'selected' : '' }}>الأربعاء</option>
                                        <option value="4" {{ old('day_of_week') == '4' ? 'selected' : '' }}>الخميس</option>
                                        <option value="5" {{ old('day_of_week') == '5' ? 'selected' : '' }}>الجمعة</option>
                                        <option value="6" {{ old('day_of_week') == '6' ? 'selected' : '' }}>السبت</option>
                                    </select>
                                    @error('day_of_week')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 frequency-options" id="monthly-options" style="display: none;">
                                <div class="form-group">
                                    <label for="day_of_month">يوم الشهر</label>
                                    <select name="day_of_month" id="day_of_month" class="form-control @error('day_of_month') is-invalid @enderror">
                                        @for($i = 1; $i <= 31; $i++)
                                            <option value="{{ $i }}" {{ old('day_of_month') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                    @error('day_of_month')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6 frequency-options" id="annual-options" style="display: none;">
                                <div class="form-group">
                                    <label for="month_of_year">شهر السنة</label>
                                    <select name="month_of_year" id="month_of_year" class="form-control @error('month_of_year') is-invalid @enderror">
                                        <option value="1" {{ old('month_of_year') == '1' ? 'selected' : '' }}>يناير</option>
                                        <option value="2" {{ old('month_of_year') == '2' ? 'selected' : '' }}>فبراير</option>
                                        <option value="3" {{ old('month_of_year') == '3' ? 'selected' : '' }}>مارس</option>
                                        <option value="4" {{ old('month_of_year') == '4' ? 'selected' : '' }}>أبريل</option>
                                        <option value="5" {{ old('month_of_year') == '5' ? 'selected' : '' }}>مايو</option>
                                        <option value="6" {{ old('month_of_year') == '6' ? 'selected' : '' }}>يونيو</option>
                                        <option value="7" {{ old('month_of_year') == '7' ? 'selected' : '' }}>يوليو</option>
                                        <option value="8" {{ old('month_of_year') == '8' ? 'selected' : '' }}>أغسطس</option>
                                        <option value="9" {{ old('month_of_year') == '9' ? 'selected' : '' }}>سبتمبر</option>
                                        <option value="10" {{ old('month_of_year') == '10' ? 'selected' : '' }}>أكتوبر</option>
                                        <option value="11" {{ old('month_of_year') == '11' ? 'selected' : '' }}>نوفمبر</option>
                                        <option value="12" {{ old('month_of_year') == '12' ? 'selected' : '' }}>ديسمبر</option>
                                    </select>
                                    @error('month_of_year')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البدء</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date') ?? date('Y-m-d') }}" required>
                                    @error('start_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="end_date">تاريخ الانتهاء (اختياري)</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date') }}">
                                    @error('end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="technician_id">الفني المسؤول</label>
                                    <select name="technician_id" id="technician_id" class="form-control @error('technician_id') is-invalid @enderror" required>
                                        <option value="">اختر الفني</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id') == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('technician_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="estimated_duration">المدة المقدرة (بالدقائق)</label>
                                    <input type="number" name="estimated_duration" id="estimated_duration" class="form-control @error('estimated_duration') is-invalid @enderror" value="{{ old('estimated_duration') ?? 60 }}" min="1" required>
                                    @error('estimated_duration')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="status">الحالة</label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>غير نشط</option>
                                <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                            </select>
                            @error('status')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" rows="3" class="form-control @error('notes') is-invalid @enderror">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('elevator-maintenance-schedules.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Show/hide frequency options based on selected frequency
        $('#frequency').change(function() {
            $('.frequency-options').hide();
            
            var frequency = $(this).val();
            if (frequency === 'weekly') {
                $('#weekly-options').show();
            } else if (frequency === 'monthly' || frequency === 'quarterly' || frequency === 'semi_annual') {
                $('#monthly-options').show();
            } else if (frequency === 'annual') {
                $('#monthly-options').show();
                $('#annual-options').show();
            }
        });
        
        // Trigger change event on page load to handle initial state
        $('#frequency').trigger('change');
    });
</script>
@endsection