@extends('layouts.app')

@section('title', 'تفاصيل عملية فحص')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل عملية فحص</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inspections.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('elevator-inspections.edit', $inspection->id) }}" class="btn btn-sm btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-elevator"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المصعد</span>
                                    <span class="info-box-number">{{ $inspection->elevator->name ?? 'غير محدد' }}</span>
                                    <span class="info-box-text text-muted">{{ $inspection->elevator->location->name ?? 'موقع غير محدد' }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-user-cog"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الفني المسؤول</span>
                                    <span class="info-box-number">{{ $inspection->technician->name ?? 'غير محدد' }}</span>
                                    <span class="info-box-text text-muted">{{ $inspection->technician->email ?? '' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-calendar-day"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تاريخ الفحص</span>
                                    <span class="info-box-number">{{ $inspection->inspection_date->format('Y-m-d') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary"><i class="fas fa-clipboard-check"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">نوع الفحص</span>
                                    <span class="info-box-number">{{ $inspection->getInspectionTypeName() }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="info-box">
                                <span class="info-box-icon {{ $inspection->status == 'completed' ? 'bg-success' : ($inspection->status == 'cancelled' ? 'bg-danger' : 'bg-info') }}">
                                    <i class="fas {{ $inspection->status == 'completed' ? 'fa-check-circle' : ($inspection->status == 'cancelled' ? 'fa-times-circle' : 'fa-clock') }}"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الحالة</span>
                                    <span class="info-box-number">{{ $inspection->getStatusName() }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">تفاصيل الفحص</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h5>ملاحظات</h5>
                                            <p>{{ $inspection->notes ?: 'لا توجد ملاحظات' }}</p>
                                            
                                            @if($inspection->status == 'completed')
                                                <hr>
                                                <h5>النتائج</h5>
                                                <p>{{ $inspection->findings ?: 'لا توجد نتائج مسجلة' }}</p>
                                                
                                                <hr>
                                                <h5>التوصيات</h5>
                                                <p>{{ $inspection->recommendations ?: 'لا توجد توصيات مسجلة' }}</p>
                                                
                                                <hr>
                                                <h5>نتيجة الفحص</h5>
                                                <p>
                                                    @if($inspection->passed === true)
                                                        <span class="badge badge-success">ناجح</span>
                                                    @elseif($inspection->passed === false)
                                                        <span class="badge badge-danger">راسب</span>
                                                    @else
                                                        <span class="badge badge-secondary">غير محدد</span>
                                                    @endif
                                                </p>
                                                
                                                @if($inspection->certificate_number)
                                                    <hr>
                                                    <h5>رقم الشهادة</h5>
                                                    <p>{{ $inspection->certificate_number }}</p>
                                                @endif
                                                
                                                @if($inspection->certificate_expiry_date)
                                                    <hr>
                                                    <h5>تاريخ انتهاء الشهادة</h5>
                                                    <p>{{ $inspection->certificate_expiry_date->format('Y-m-d') }}</p>
                                                @endif
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($inspection->status == 'scheduled' || $inspection->status == 'in_progress')
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <button type="button" class="btn btn-success btn-block" data-toggle="modal" data-target="#completeModal">
                                    <i class="fas fa-check-circle"></i> إكمال عملية الفحص
                                </button>
                            </div>
                            <div class="col-md-6">
                                <button type="button" class="btn btn-danger btn-block" data-toggle="modal" data-target="#cancelModal">
                                    <i class="fas fa-times-circle"></i> إلغاء عملية الفحص
                                </button>
                            </div>
                        </div>
                        
                        <!-- Modal Complete -->
                        <div class="modal fade" id="completeModal" tabindex="-1" role="dialog" aria-labelledby="completeModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <form action="{{ route('elevator-inspections.complete', $inspection->id) }}" method="POST">
                                        @csrf
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="completeModalLabel">إكمال عملية الفحص</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="findings">النتائج</label>
                                                <textarea name="findings" id="findings" class="form-control" rows="3" required></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="recommendations">التوصيات</label>
                                                <textarea name="recommendations" id="recommendations" class="form-control" rows="3" required></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label>نتيجة الفحص</label>
                                                <div class="custom-control custom-radio">
                                                    <input class="custom-control-input" type="radio" id="passed" name="passed" value="1" checked>
                                                    <label for="passed" class="custom-control-label">ناجح</label>
                                                </div>
                                                <div class="custom-control custom-radio">
                                                    <input class="custom-control-input" type="radio" id="failed" name="passed" value="0">
                                                    <label for="failed" class="custom-control-label">راسب</label>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="certificate_number">رقم الشهادة (اختياري)</label>
                                                <input type="text" name="certificate_number" id="certificate_number" class="form-control">
                                            </div>
                                            <div class="form-group">
                                                <label for="certificate_expiry_date">تاريخ انتهاء الشهادة (اختياري)</label>
                                                <input type="date" name="certificate_expiry_date" id="certificate_expiry_date" class="form-control">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                            <button type="submit" class="btn btn-success">إكمال الفحص</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Modal Cancel -->
                        <div class="modal fade" id="cancelModal" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <form action="{{ route('elevator-inspections.cancel', $inspection->id) }}" method="POST">
                                        @csrf
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="cancelModalLabel">إلغاء عملية الفحص</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <label for="notes">سبب الإلغاء</label>
                                                <textarea name="notes" id="notes" class="form-control" rows="3" required></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                                            <button type="submit" class="btn btn-danger">إلغاء الفحص</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection