@extends('layouts.app')

@section('title', 'عمليات فحص المصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة عمليات فحص المصاعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inspections.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة عملية فحص جديدة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible m-3">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المصعد</th>
                                <th>نوع الفحص</th>
                                <th>تاريخ الفحص</th>
                                <th>الفني المسؤول</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($inspections as $inspection)
                                <tr>
                                    <td>{{ $inspection->id }}</td>
                                    <td>{{ $inspection->elevator->name ?? 'غير محدد' }}</td>
                                    <td>{{ $inspection->getInspectionTypeName() }}</td>
                                    <td>{{ $inspection->inspection_date->format('Y-m-d') }}</td>
                                    <td>{{ $inspection->technician->name ?? 'غير محدد' }}</td>
                                    <td>
                                        @if($inspection->status == 'scheduled')
                                            <span class="badge badge-warning">{{ $inspection->getStatusName() }}</span>
                                        @elseif($inspection->status == 'in_progress')
                                            <span class="badge badge-info">{{ $inspection->getStatusName() }}</span>
                                        @elseif($inspection->status == 'completed')
                                            <span class="badge badge-success">{{ $inspection->getStatusName() }}</span>
                                        @elseif($inspection->status == 'cancelled')
                                            <span class="badge badge-danger">{{ $inspection->getStatusName() }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('elevator-inspections.show', $inspection->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('elevator-inspections.edit', $inspection->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @if($inspection->status == 'scheduled' || $inspection->status == 'in_progress')
                                                <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#completeModal{{ $inspection->id }}">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#cancelModal{{ $inspection->id }}">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            @endif
                                            <form action="{{ route('elevator-inspections.destroy', $inspection->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الفحص؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <!-- Modal Complete -->
                                        <div class="modal fade" id="completeModal{{ $inspection->id }}" tabindex="-1" role="dialog" aria-labelledby="completeModalLabel{{ $inspection->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <form action="{{ route('elevator-inspections.complete', $inspection->id) }}" method="POST">
                                                        @csrf
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="completeModalLabel{{ $inspection->id }}">إكمال عملية الفحص</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="findings">النتائج</label>
                                                                <textarea name="findings" id="findings" class="form-control" rows="3" required></textarea>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="recommendations">التوصيات</label>
                                                                <textarea name="recommendations" id="recommendations" class="form-control" rows="3" required></textarea>
                                                            </div>
                                                            <div class="form-group">
                                                                <label>نتيجة الفحص</label>
                                                                <div class="custom-control custom-radio">
                                                                    <input class="custom-control-input" type="radio" id="passed{{ $inspection->id }}" name="passed" value="1" checked>
                                                                    <label for="passed{{ $inspection->id }}" class="custom-control-label">ناجح</label>
                                                                </div>
                                                                <div class="custom-control custom-radio">
                                                                    <input class="custom-control-input" type="radio" id="failed{{ $inspection->id }}" name="passed" value="0">
                                                                    <label for="failed{{ $inspection->id }}" class="custom-control-label">راسب</label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="certificate_number">رقم الشهادة (اختياري)</label>
                                                                <input type="text" name="certificate_number" id="certificate_number" class="form-control">
                                                            </div>
                                                            <div class="form-group">
                                                                <label for="certificate_expiry_date">تاريخ انتهاء الشهادة (اختياري)</label>
                                                                <input type="date" name="certificate_expiry_date" id="certificate_expiry_date" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <button type="submit" class="btn btn-success">إكمال الفحص</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal Cancel -->
                                        <div class="modal fade" id="cancelModal{{ $inspection->id }}" tabindex="-1" role="dialog" aria-labelledby="cancelModalLabel{{ $inspection->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <form action="{{ route('elevator-inspections.cancel', $inspection->id) }}" method="POST">
                                                        @csrf
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="cancelModalLabel{{ $inspection->id }}">إلغاء عملية الفحص</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="form-group">
                                                                <label for="notes">سبب الإلغاء</label>
                                                                <textarea name="notes" id="notes" class="form-control" rows="3" required></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                                                            <button type="submit" class="btn btn-danger">إلغاء الفحص</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد عمليات فحص مسجلة</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $inspections->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection