@extends('layouts.app')

@section('title', 'تعديل عملية فحص')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">تعديل عملية فحص</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-inspections.update', $inspection->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="elevator_id">المصعد</label>
                            <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror" required>
                                <option value="">اختر المصعد</option>
                                @foreach($elevators as $elevator)
                                    <option value="{{ $elevator->id }}" {{ old('elevator_id', $inspection->elevator_id) == $elevator->id ? 'selected' : '' }}>
                                        {{ $elevator->name }} - {{ $elevator->location->name ?? 'غير محدد' }}
                                    </option>
                                @endforeach
                            </select>
                            @error('elevator_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="technician_id">الفني المسؤول</label>
                            <select name="technician_id" id="technician_id" class="form-control @error('technician_id') is-invalid @enderror" required>
                                <option value="">اختر الفني</option>
                                @foreach($technicians as $technician)
                                    <option value="{{ $technician->id }}" {{ old('technician_id', $inspection->technician_id) == $technician->id ? 'selected' : '' }}>
                                        {{ $technician->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('technician_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="inspection_date">تاريخ الفحص</label>
                            <input type="date" class="form-control @error('inspection_date') is-invalid @enderror" id="inspection_date" name="inspection_date" value="{{ old('inspection_date', $inspection->inspection_date->format('Y-m-d')) }}" required>
                            @error('inspection_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="inspection_type">نوع الفحص</label>
                            <select name="inspection_type" id="inspection_type" class="form-control @error('inspection_type') is-invalid @enderror" required>
                                <option value="routine" {{ old('inspection_type', $inspection->inspection_type) == 'routine' ? 'selected' : '' }}>فحص روتيني</option>
                                <option value="safety" {{ old('inspection_type', $inspection->inspection_type) == 'safety' ? 'selected' : '' }}>فحص سلامة</option>
                                <option value="certification" {{ old('inspection_type', $inspection->inspection_type) == 'certification' ? 'selected' : '' }}>فحص شهادة</option>
                                <option value="complaint" {{ old('inspection_type', $inspection->inspection_type) == 'complaint' ? 'selected' : '' }}>فحص شكوى</option>
                                <option value="other" {{ old('inspection_type', $inspection->inspection_type) == 'other' ? 'selected' : '' }}>فحص آخر</option>
                            </select>
                            @error('inspection_type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="status">الحالة</label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                <option value="scheduled" {{ old('status', $inspection->status) == 'scheduled' ? 'selected' : '' }}>مجدول</option>
                                <option value="in_progress" {{ old('status', $inspection->status) == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                <option value="completed" {{ old('status', $inspection->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                <option value="cancelled" {{ old('status', $inspection->status) == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                            </select>
                            @error('status')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $inspection->notes) }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="findings">النتائج</label>
                            <textarea class="form-control @error('findings') is-invalid @enderror" id="findings" name="findings" rows="3">{{ old('findings', $inspection->findings) }}</textarea>
                            @error('findings')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="recommendations">التوصيات</label>
                            <textarea class="form-control @error('recommendations') is-invalid @enderror" id="recommendations" name="recommendations" rows="3">{{ old('recommendations', $inspection->recommendations) }}</textarea>
                            @error('recommendations')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>نتيجة الفحص</label>
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" id="passed" name="passed" value="1" {{ old('passed', $inspection->passed) ? 'checked' : '' }}>
                                <label for="passed" class="custom-control-label">ناجح</label>
                            </div>
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" id="failed" name="passed" value="0" {{ old('passed', $inspection->passed) === false ? 'checked' : '' }}>
                                <label for="failed" class="custom-control-label">راسب</label>
                            </div>
                            @error('passed')
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="certificate_number">رقم الشهادة</label>
                            <input type="text" class="form-control @error('certificate_number') is-invalid @enderror" id="certificate_number" name="certificate_number" value="{{ old('certificate_number', $inspection->certificate_number) }}">
                            @error('certificate_number')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="certificate_expiry_date">تاريخ انتهاء الشهادة</label>
                            <input type="date" class="form-control @error('certificate_expiry_date') is-invalid @enderror" id="certificate_expiry_date" name="certificate_expiry_date" value="{{ old('certificate_expiry_date', $inspection->certificate_expiry_date ? $inspection->certificate_expiry_date->format('Y-m-d') : '') }}">
                            @error('certificate_expiry_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning">تحديث</button>
                        <a href="{{ route('elevator-inspections.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection