@extends('layouts.app')

@section('title', 'إضافة عملية فحص جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">إضافة عملية فحص جديدة</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-inspections.store') }}">
                    @csrf
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="form-group">
                            <label for="elevator_id">المصعد</label>
                            <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror" required>
                                <option value="">اختر المصعد</option>
                                @foreach($elevators as $elevator)
                                    <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                        {{ $elevator->name }} - {{ $elevator->location->name ?? 'غير محدد' }}
                                    </option>
                                @endforeach
                            </select>
                            @error('elevator_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="technician_id">الفني المسؤول</label>
                            <select name="technician_id" id="technician_id" class="form-control @error('technician_id') is-invalid @enderror" required>
                                <option value="">اختر الفني</option>
                                @foreach($technicians as $technician)
                                    <option value="{{ $technician->id }}" {{ old('technician_id') == $technician->id ? 'selected' : '' }}>
                                        {{ $technician->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('technician_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="inspection_date">تاريخ الفحص</label>
                            <input type="date" class="form-control @error('inspection_date') is-invalid @enderror" id="inspection_date" name="inspection_date" value="{{ old('inspection_date', date('Y-m-d')) }}" required>
                            @error('inspection_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="inspection_type">نوع الفحص</label>
                            <select name="inspection_type" id="inspection_type" class="form-control @error('inspection_type') is-invalid @enderror" required>
                                <option value="routine" {{ old('inspection_type') == 'routine' ? 'selected' : '' }}>فحص روتيني</option>
                                <option value="safety" {{ old('inspection_type') == 'safety' ? 'selected' : '' }}>فحص سلامة</option>
                                <option value="certification" {{ old('inspection_type') == 'certification' ? 'selected' : '' }}>فحص شهادة</option>
                                <option value="complaint" {{ old('inspection_type') == 'complaint' ? 'selected' : '' }}>فحص شكوى</option>
                                <option value="other" {{ old('inspection_type') == 'other' ? 'selected' : '' }}>فحص آخر</option>
                            </select>
                            @error('inspection_type')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ</button>
                        <a href="{{ route('elevator-inspections.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection