@extends('layouts.app')

@section('title', 'عمليات فحص المصاعد المكتملة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة عمليات فحص المصاعد المكتملة</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inspections.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة عملية فحص جديدة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible m-3">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المصعد</th>
                                <th>نوع الفحص</th>
                                <th>تاريخ الفحص</th>
                                <th>الفني المسؤول</th>
                                <th>نتيجة الفحص</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($inspections as $inspection)
                                <tr>
                                    <td>{{ $inspection->id }}</td>
                                    <td>{{ $inspection->elevator->name ?? 'غير محدد' }}</td>
                                    <td>{{ $inspection->getInspectionTypeName() }}</td>
                                    <td>{{ $inspection->inspection_date->format('Y-m-d') }}</td>
                                    <td>{{ $inspection->technician->name ?? 'غير محدد' }}</td>
                                    <td>
                                        @if($inspection->passed === true)
                                            <span class="badge badge-success">ناجح</span>
                                        @elseif($inspection->passed === false)
                                            <span class="badge badge-danger">راسب</span>
                                        @else
                                            <span class="badge badge-secondary">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('elevator-inspections.show', $inspection->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('elevator-inspections.edit', $inspection->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد عمليات فحص مكتملة</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $inspections->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection