@extends('layouts.modern')

@section('title', 'لوحة التحكم')

@section('header', 'لوحة التحكم')

@section('breadcrumb')
    <li class="breadcrumb-item active">لوحة التحكم</li>
@endsection

@section('content')
<div class="row fade-in" style="width:100%; max-width:100%; margin-left:0; margin-right:0; box-sizing:border-box; overflow-x:hidden;">
    <div class="col-md-12 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title fw-bold">مرحباً بك في {{ $company->name }}</h5>
                <p class="card-text">فيما يلي نظرة عامة على عمليات شركتك.</p>
            </div>
        </div>
    </div>
</div>

@if(isset($data['urgent_notifications']) && count($data['urgent_notifications']) > 0)
<div class="row fade-in delay-1" style="width:100%; max-width:100%; margin-left:0; margin-right:0; box-sizing:border-box; overflow-x:hidden;">
    <div class="col-md-12 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card">
            <div class="card-header bg-danger text-white py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 fw-bold">إشعارات عاجلة تتطلب اهتمامك!</h6>
                <a href="{{ route('notifications.index', ['priority' => 'high']) }}" class="btn btn-sm btn-outline-light">عرض كل الإشعارات العاجلة</a>
            </div>
            <div class="card-body">
                <div class="urgent-notifications">
                    @foreach($data['urgent_notifications'] as $notification)
                        <div class="notification-item d-flex align-items-start mb-3 p-3 rounded {{ $notification->type == 'maintenance_critical_overdue' ? 'bg-danger-subtle' : 'bg-warning-subtle' }}">
                            <div class="notification-icon me-3 rounded-circle {{ $notification->type == 'maintenance_critical_overdue' ? 'bg-danger' : 'bg-warning' }} text-white">
                                @if($notification->type == 'maintenance_urgent')
                                    <i class="fas fa-exclamation-circle"></i>
                                @elseif($notification->type == 'maintenance_today')
                                    <i class="fas fa-calendar-day"></i>
                                @elseif($notification->type == 'maintenance_overdue')
                                    <i class="fas fa-exclamation-triangle"></i>
                                @elseif($notification->type == 'maintenance_critical_overdue')
                                    <i class="fas fa-radiation"></i>
                                @else
                                    <i class="fas fa-bell"></i>
                                @endif
                            </div>
                            <div class="notification-content">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6 class="notification-title fw-bold mb-1">{{ $notification->title }}</h6>
                                    <span class="badge {{ $notification->type == 'maintenance_critical_overdue' ? 'bg-danger' : 'bg-warning' }}">
                                        {{ $notification->created_at->diffForHumans() }}
                                    </span>
                                </div>
                                <p class="mb-2">{{ Str::limit($notification->message, 120) }}</p>
                                <div class="mt-2">
                                    <a href="{{ route('notifications.show', $notification->id) }}" class="btn btn-sm btn-outline-dark">
                                        عرض التفاصيل
                                    </a>
                                    @if(isset($notification->data['schedule_id']))
                                        <a href="{{ route('maintenance-schedules.show', $notification->data['schedule_id']) }}" class="btn btn-sm btn-outline-primary">
                                            عرض جدولة الصيانة
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<div class="row fade-in delay-2" style="width:100%; max-width:100%; margin-left:0; margin-right:0; box-sizing:border-box; overflow-x:hidden;">
    <!-- Customers Card -->
    <div class="col-xl-3 col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="stat-card primary">
            <div class="stat-title">العملاء</div>
            <div class="stat-value">{{ $data['customers_count'] }}</div>
            <div class="stat-actions">
                <a href="{{ route('customers.index') }}" class="btn btn-sm btn-light">عرض الكل</a>
                <a href="{{ route('customers.create') }}" class="btn btn-sm btn-outline-light">إضافة جديد</a>
            </div>
            <div class="icon">
                <i class="fas fa-users"></i>
            </div>
        </div>
    </div>

    <!-- Elevators Card -->
    <div class="col-xl-3 col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="stat-card success">
            <div class="stat-title">المصاعد</div>
            <div class="stat-value">{{ $data['elevators_count'] }}</div>
            <div class="stat-actions">
                <a href="{{ route('elevators.index') }}" class="btn btn-sm btn-light">عرض الكل</a>
                <a href="{{ route('elevators.create') }}" class="btn btn-sm btn-outline-light">إضافة جديد</a>
            </div>
            <div class="icon">
                <i class="fas fa-building"></i>
            </div>
        </div>
    </div>

    <!-- Contracts Card -->
    <div class="col-xl-3 col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="stat-card warning">
            <div class="stat-title">العقود النشطة</div>
            <div class="stat-value">{{ $data['active_contracts_count'] }}</div>
            <div class="stat-actions">
                <a href="{{ route('maintenance-contracts.index') }}" class="btn btn-sm btn-light">عرض الكل</a>
                <a href="{{ route('maintenance-contracts.create') }}" class="btn btn-sm btn-outline-light">إضافة جديد</a>
            </div>
            <div class="icon">
                <i class="fas fa-file-contract"></i>
            </div>
        </div>
    </div>

    <!-- Invoices Card -->
    <div class="col-xl-3 col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="stat-card danger">
            <div class="stat-title">الفواتير غير المدفوعة</div>
            <div class="stat-value">{{ $data['unpaid_invoices_count'] }}</div>
            <div class="stat-actions">
                <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-light">عرض الكل</a>
                <a href="{{ route('invoices.create') }}" class="btn btn-sm btn-outline-light">إضافة جديد</a>
            </div>
            <div class="icon">
                <i class="fas fa-file-invoice-dollar"></i>
            </div>
        </div>
    </div>
</div>

<div class="row fade-in delay-3" style="width:100%; max-width:100%; margin-left:0; margin-right:0; box-sizing:border-box; overflow-x:hidden;">
    <!-- Financial Summary -->
    <div class="col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="m-0 fw-bold">ملخص مالي</h6>
                <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-chart-line me-1"></i> التقارير المالية
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                            <tr>
                                <td class="fw-bold">إجمالي مبلغ الفواتير</td>
                                <td class="text-end">{{ $company->currency }} {{ number_format($data['total_invoices_amount'], 2) }}</td>
                            </tr>
                            <tr>
                                <td class="fw-bold">إجمالي المبلغ المستحق</td>
                                <td class="text-end">{{ $company->currency }} {{ number_format($data['total_due_amount'], 2) }}</td>
                            </tr>
                            <tr>
                                <td class="fw-bold">معدل التحصيل</td>
                                <td class="text-end">
                                    @if($data['total_invoices_amount'] > 0)
                                        <span class="badge bg-{{ (100 - ($data['total_due_amount'] / $data['total_invoices_amount'] * 100)) > 70 ? 'success' : 'warning' }} p-2">
                                            {{ number_format(100 - ($data['total_due_amount'] / $data['total_invoices_amount'] * 100), 2) }}%
                                        </span>
                                    @else
                                        <span class="badge bg-secondary p-2">0%</span>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Business Overview -->
    <div class="col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="m-0 fw-bold">نظرة عامة على الأعمال</h6>
                <a href="{{ route('dashboard') }}" class="btn btn-sm btn-primary">
                    <i class="fas fa-sync-alt me-1"></i> تحديث
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                            <tr>
                                <td class="fw-bold">إجمالي الفروع</td>
                                <td class="text-end">
                                    <a href="{{ route('branches.index') }}" class="badge bg-info p-2">{{ $data['branches_count'] }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">إجمالي العقود</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-contracts.index') }}" class="badge bg-primary p-2">{{ $data['contracts_count'] }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">إجمالي الفواتير</td>
                                <td class="text-end">
                                    <a href="{{ route('invoices.index') }}" class="badge bg-success p-2">{{ $data['invoices_count'] }}</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row fade-in delay-4" style="width:100%; max-width:100%; margin-left:0; margin-right:0; box-sizing:border-box; overflow-x:hidden;">
    <!-- Maintenance Overview -->
    <div class="col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6 class="m-0 fw-bold">ملخص الصيانة</h6>
                <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-sm btn-success">
                    <i class="fas fa-tools me-1"></i> عرض الكل
                </a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                            <tr>
                                <td class="fw-bold">الصيانة المستحقة اليوم</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-schedules.index', ['status' => 'scheduled', 'date_range' => 'today']) }}" class="badge bg-primary p-2">{{ $data['maintenance_due_today'] ?? 0 }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">الصيانة العاجلة (خلال يومين)</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-schedules.index', ['status' => 'scheduled', 'date_range' => 'urgent']) }}" class="badge bg-warning p-2">{{ $data['maintenance_urgent'] ?? 0 }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">الصيانة المستحقة هذا الأسبوع</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-schedules.index', ['status' => 'scheduled', 'date_range' => 'this_week']) }}" class="badge bg-info p-2">{{ $data['maintenance_due_this_week'] ?? 0 }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">الصيانة المتأخرة</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-schedules.index', ['status' => 'scheduled', 'date_range' => 'overdue']) }}" class="badge bg-danger p-2">{{ $data['maintenance_overdue'] ?? 0 }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">الصيانة المتأخرة بشكل حرج (> 7 أيام)</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-schedules.index', ['status' => 'scheduled', 'date_range' => 'critical_overdue']) }}" class="badge bg-danger p-2" style="background-color: #d9534f;">{{ $data['maintenance_critical_overdue'] ?? 0 }}</a>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-bold">العقود التي ستنتهي قريباً</td>
                                <td class="text-end">
                                    <a href="{{ route('maintenance-contracts.index', ['status' => 'active', 'expiring' => 'soon']) }}" class="badge bg-warning p-2">{{ $data['contracts_expiring_soon'] ?? 0 }}</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Notifications -->
    <div class="col-md-6 mb-4" style="padding-left:10px; padding-right:10px; max-width:100%; box-sizing:border-box;">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-danger">آخر الإشعارات</h6>
                <a href="{{ route('notifications.index') }}" class="btn btn-sm btn-danger">عرض الكل</a>
            </div>
            <div class="card-body">
                <div class="notifications-list">
                    @if(isset($data['recent_notifications']) && count($data['recent_notifications']) > 0)
                        @foreach($data['recent_notifications'] as $notification)
                            <div class="notification-item d-flex align-items-center mb-2 p-2 border-bottom">
                                <div class="mr-3">
                                    @if($notification->type == 'maintenance_due')
                                        <i class="fas fa-tools text-info"></i>
                                    @elseif($notification->type == 'maintenance_urgent')
                                        <i class="fas fa-exclamation-circle text-warning"></i>
                                    @elseif($notification->type == 'maintenance_today')
                                        <i class="fas fa-calendar-day text-primary"></i>
                                    @elseif($notification->type == 'maintenance_overdue')
                                        <i class="fas fa-exclamation-triangle text-danger"></i>
                                    @elseif($notification->type == 'maintenance_critical_overdue')
                                        <i class="fas fa-radiation text-danger"></i>
                                    @elseif($notification->type == 'contract_expiring')
                                        <i class="fas fa-file-contract text-warning"></i>
                                    @else
                                        <i class="fas fa-bell text-secondary"></i>
                                    @endif
                                </div>
                                <div>
                                    <a href="{{ route('notifications.show', $notification->id) }}" class="notification-title">
                                        {{ $notification->title }}
                                    </a>
                                    <div class="notification-meta">
                                        <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="text-center py-3">
                            <i class="fas fa-bell-slash fa-2x text-muted mb-2"></i>
                            <p>لا توجد إشعارات جديدة</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection