@extends('layouts.modern')

@section('title', $customer->name)

@section('header', $customer->name)

@section('content')
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Customer Information</h6>
                <div>
                    @if(auth()->user()->can('edit customers') || auth()->user()->id == $customer->user_id)
                    <a href="{{ route('customers.edit', $customer->id) }}" class="btn btn-primary btn-sm">
                        <i class="bi bi-pencil"></i> Edit
                    </a>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <h5 class="font-weight-bold">{{ $customer->name }}</h5>
                    <p class="mb-1">
                        <span class="badge bg-{{ $customer->status == 'active' ? 'success' : ($customer->status == 'inactive' ? 'danger' : ($customer->status == 'lead' ? 'warning' : 'info')) }}">
                            {{ ucfirst($customer->status) }}
                        </span>
                        <span class="badge bg-secondary">{{ ucfirst($customer->type) }}</span>
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Contact Information</h6>
                    @if($customer->email)
                        <p class="mb-1"><i class="bi bi-envelope me-2"></i> {{ $customer->email }}</p>
                    @endif
                    @if($customer->phone)
                        <p class="mb-1"><i class="bi bi-telephone me-2"></i> {{ $customer->phone }}</p>
                    @endif
                    @if($customer->tax_number)
                        <p class="mb-1"><i class="bi bi-card-list me-2"></i> Tax Number: {{ $customer->tax_number }}</p>
                    @endif
                </div>
                
                @if($customer->contact_person)
                <div class="mb-3">
                    <h6 class="font-weight-bold">Contact Person</h6>
                    <p class="mb-1"><strong>Name:</strong> {{ $customer->contact_person }}</p>
                    @if($customer->contact_position)
                        <p class="mb-1"><strong>Position:</strong> {{ $customer->contact_position }}</p>
                    @endif
                    @if($customer->contact_phone)
                        <p class="mb-1"><strong>Phone:</strong> {{ $customer->contact_phone }}</p>
                    @endif
                </div>
                @endif
                
                @if($customer->address || $customer->city || $customer->state || $customer->country)
                <div class="mb-3">
                    <h6 class="font-weight-bold">Address</h6>
                    @if($customer->address)
                        <p class="mb-1">{{ $customer->address }}</p>
                    @endif
                    <p class="mb-1">
                        @if($customer->city){{ $customer->city }}@endif
                        @if($customer->state){{ $customer->city ? ', ' : '' }}{{ $customer->state }}@endif
                        @if($customer->postal_code){{ ($customer->city || $customer->state) ? ' ' : '' }}{{ $customer->postal_code }}@endif
                    </p>
                    @if($customer->country)
                        <p class="mb-1">{{ $customer->country }}</p>
                    @endif
                </div>
                @endif
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Company & Branch</h6>
                    <p class="mb-1"><strong>Company:</strong> 
                        @if($customer->company)
                            <a href="{{ route('companies.show', $customer->company_id) }}">{{ $customer->company->name }}</a>
                        @else
                            <span class="text-muted">Not assigned</span>
                        @endif
                    </p>
                    <p class="mb-1"><strong>Branch:</strong> 
                        @if($customer->branch_id && isset($customer->branch) && $customer->branch)
                            <a href="{{ route('branches.show', $customer->branch_id) }}">{{ $customer->branch->name }}</a>
                        @else
                            <span class="text-muted">Not assigned</span>
                        @endif
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">Account Information</h6>
                    <p class="mb-1"><strong>Assigned To:</strong> 
                        @if($customer->user_id && isset($customer->user) && $customer->user)
                            <a href="{{ route('users.show', $customer->user_id) }}">{{ $customer->user->name }}</a>
                        @else
                            <span class="text-muted">Not assigned</span>
                        @endif
                    </p>
                    <p class="mb-1"><strong>Created:</strong> {{ $customer->created_at->format('M d, Y') }}</p>
                    <p class="mb-1"><strong>Last Updated:</strong> {{ $customer->updated_at->format('M d, Y') }}</p>
                </div>
                
                @if($customer->notes)
                <div class="mb-3">
                    <h6 class="font-weight-bold">Notes</h6>
                    <p class="mb-1">{{ $customer->notes }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-8 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Customer Overview</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Elevators</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['elevators_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-arrow-up-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Locations</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['locations_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-geo-alt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Contracts</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['contracts_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-file-earmark-text fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-6 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Invoices</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['invoices_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-receipt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Invoiced</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistics['total_invoiced'], 2) }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-cash-stack fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Total Paid</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistics['total_paid'], 2) }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-check-circle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-left-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            Total Due</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($statistics['total_due'], 2) }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-exclamation-circle fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('locations.index', ['customer_id' => $customer->id]) }}" class="btn btn-success">
                                <i class="bi bi-geo-alt"></i> View Locations
                            </a>
                            <a href="{{ route('elevators.index', ['customer_id' => $customer->id]) }}" class="btn btn-info">
                                <i class="bi bi-arrow-up-square"></i> View Elevators
                            </a>
                            <a href="{{ route('maintenance-contracts.index', ['customer_id' => $customer->id]) }}" class="btn btn-warning">
                                <i class="bi bi-file-earmark-text"></i> View Contracts
                            </a>
                            <a href="{{ route('invoices.index', ['customer_id' => $customer->id]) }}" class="btn btn-danger">
                                <i class="bi bi-receipt"></i> View Invoices
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">Recent Elevators</h6>
                <a href="{{ route('elevators.index', ['customer_id' => $customer->id]) }}" class="btn btn-sm btn-primary">View All</a>
            </div>
            <div class="card-body">
                @if($customer->elevators()->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Serial Number</th>
                                <th>Model</th>
                                <th>Location</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customer->elevators()->latest()->take(5)->get() as $elevator)
                            <tr>
                                <td>{{ $elevator->serial_number }}</td>
                                <td>{{ $elevator->model }}</td>
                                <td>{{ $elevator->location ? $elevator->location->name : 'N/A' }}</td>
                                <td>
                                    <span class="badge bg-{{ $elevator->status == 'operational' ? 'success' : ($elevator->status == 'maintenance' ? 'warning' : 'danger') }}">
                                        {{ ucfirst($elevator->status) }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-info btn-sm">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="text-center py-3">
                    <p>No elevators found for this customer.</p>
                    <a href="{{ route('elevators.create', ['customer_id' => $customer->id]) }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> Add Elevator
                    </a>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection