@extends('layouts.modern')

@section('title', 'العملاء')

@section('header', 'العملاء')

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">جميع العملاء</h6>
        <div class="d-flex">
            <a href="{{ route('customers.export') }}{{ request()->getQueryString() ? '?' . request()->getQueryString() : '' }}" class="btn btn-success btn-sm me-2">
                <i class="bi bi-file-earmark-arrow-down"></i> تصدير إلى Excel
            </a>
            <a href="{{ route('customers.import.form') }}" class="btn btn-info btn-sm me-2">
                <i class="bi bi-file-earmark-arrow-up"></i> استيراد من Excel
            </a>
            @if(auth()->user()->hasPermissionTo('create_customer') || auth()->user()->hasPermissionTo('manage_customers'))
            <a href="{{ route('customers.create') }}" class="btn btn-primary btn-sm">
                <i class="bi bi-plus-circle"></i> إضافة عميل جديد
            </a>
            @endif
        </div>
    </div>
    <div class="card-body">
        <!-- أزرار تصفية سريعة -->
        <div class="mb-3">
            <div class="btn-group" role="group" aria-label="فلترة العملاء">
                <a href="{{ route('customers.index') }}" class="btn btn-outline-secondary">الكل</a>
                <a href="{{ route('customers.index', ['status' => 'active']) }}" class="btn btn-outline-success">العملاء النشطين</a>
                <a href="{{ route('customers.index', ['status' => 'lead']) }}" class="btn btn-outline-warning">العملاء المحتملين</a>
                <a href="{{ route('customers.index', ['status' => 'prospect']) }}" class="btn btn-outline-info">العملاء المتوقعين</a>
                <a href="{{ route('customers.index', ['status' => 'inactive']) }}" class="btn btn-outline-danger">العملاء غير النشطين</a>
            </div>
        </div>
        
        <div class="mb-3">
            <form action="{{ route('customers.index') }}" method="GET" class="row g-3">
                <div class="col-md-3">
                    <div class="input-group">
                        <input type="text" class="form-control" id="search" name="search" placeholder="بحث..." value="{{ request('search') }}">
                        <button class="btn btn-outline-secondary" type="submit">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </div>
                <div class="col-md-2">
                    <select class="form-select" id="branch_id" name="branch_id">
                        <option value="">جميع الفروع</option>
                        @foreach($branches as $branch)
                            <option value="{{ $branch->id }}" {{ request('branch_id') == $branch->id ? 'selected' : '' }}>
                                {{ $branch->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select class="form-select" id="user_id" name="user_id">
                        <option value="">جميع المستخدمين</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select class="form-select" id="type" name="type">
                        <option value="">جميع الأنواع</option>
                        @foreach($types as $type)
                            <option value="{{ $type }}" {{ request('type') == $type ? 'selected' : '' }}>
                                @if($type == 'individual')
                                    فرد
                                @elseif($type == 'company')
                                    شركة
                                @elseif($type == 'government')
                                    حكومي
                                @else
                                    {{ ucfirst($type) }}
                                @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select class="form-select" id="status" name="status">
                        <option value="">جميع الحالات</option>
                        @foreach($statuses as $status)
                            <option value="{{ $status }}" {{ request('status') == $status ? 'selected' : '' }}>
                                @if($status == 'active')
                                    نشط
                                @elseif($status == 'inactive')
                                    غير نشط
                                @elseif($status == 'lead')
                                    عميل محتمل
                                @elseif($status == 'prospect')
                                    عميل متوقع
                                @else
                                    {{ ucfirst($status) }}
                                @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-1">
                    <a href="{{ route('customers.index') }}" class="btn btn-secondary w-100">
                        <i class="bi bi-x-circle"></i>
                    </a>
                </div>
            </form>
        </div>
        
        @if($customers->count() > 0)
        <div class="table-responsive">
            <table class="table table-bordered" width="100%" cellspacing="0">
                <thead>
                    <tr>
                        <th>الاسم</th>
                        <th>النوع</th>
                        <th>معلومات الاتصال</th>
                        <th>الفرع</th>
                        <th>المسؤول</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customers as $customer)
                    <tr>
                        <td>
                            <a href="{{ route('customers.show', $customer->id) }}">{{ $customer->name }}</a>
                            @if($customer->tax_number)
                                <br><small class="text-muted">الرقم الضريبي: {{ $customer->tax_number }}</small>
                            @endif
                        </td>
                        <td>
                            @if($customer->type == 'individual')
                                فرد
                            @elseif($customer->type == 'company')
                                شركة
                            @elseif($customer->type == 'government')
                                حكومي
                            @else
                                {{ ucfirst($customer->type) }}
                            @endif
                        </td>
                        <td>
                            @if($customer->email)
                                <small><i class="bi bi-envelope"></i> {{ $customer->email }}</small><br>
                            @endif
                            @if($customer->phone)
                                <small><i class="bi bi-telephone"></i> {{ $customer->phone }}</small>
                            @endif
                        </td>
                        <td>{{ $customer->branch ? $customer->branch->name : 'غير محدد' }}</td>
                        <td>{{ $customer->user ? $customer->user->name : 'غير محدد' }}</td>
                        <td>
                            @if($customer->status == 'active')
                                <span class="badge bg-success">نشط</span>
                            @elseif($customer->status == 'inactive')
                                <span class="badge bg-danger">غير نشط</span>
                            @elseif($customer->status == 'lead')
                                <span class="badge bg-warning">عميل محتمل</span>
                            @elseif($customer->status == 'prospect')
                                <span class="badge bg-info">عميل متوقع</span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('customers.show', $customer->id) }}" class="btn btn-info btn-sm">
                                <i class="bi bi-eye"></i>
                            </a>
                            @if(auth()->user()->hasPermissionTo('edit_customer') || auth()->user()->hasPermissionTo('manage_customers') || auth()->user()->id == $customer->user_id)
                            <a href="{{ route('customers.edit', $customer->id) }}" class="btn btn-primary btn-sm">
                                <i class="bi bi-pencil"></i>
                            </a>
                            @endif
                            @if(auth()->user()->hasPermissionTo('delete_customer') || auth()->user()->hasPermissionTo('manage_customers'))
                            <form action="{{ route('customers.destroy', $customer->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا العميل؟')">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center mt-4">
            {{ $customers->appends(request()->query())->links() }}
        </div>
        @else
        <div class="text-center py-4">
            <h4>لم يتم العثور على عملاء</h4>
            <p>لا يوجد عملاء مطابقين لمعايير البحث.</p>
            @if(auth()->user()->hasPermissionTo('create_customer') || auth()->user()->hasPermissionTo('manage_customers'))
            <a href="{{ route('customers.create') }}" class="btn btn-primary mt-3">
                <i class="bi bi-plus-circle"></i> إضافة عميل جديد
            </a>
            @endif
        </div>
        @endif
    </div>
</div>
@endsection