@extends('layouts.modern')

@section('title', 'استيراد العملاء')

@section('header', 'استيراد العملاء من ملف Excel')

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">استيراد العملاء من ملف Excel</h6>
        <a href="{{ route('customers.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-right"></i> العودة إلى قائمة العملاء
        </a>
    </div>

    <div class="card-body">
        @include('layouts.alerts')

        <div class="alert alert-info">
            <h5><i class="bi bi-info-circle"></i> تعليمات الاستيراد:</h5>
            <ul>
                <li>يجب أن يكون الملف بتنسيق Excel (.xlsx, .xls) أو CSV.</li>
                <li>يجب أن يحتوي الملف على العناوين التالية في الصف الأول:
                    <ul>
                        <li><code>name</code> - اسم العميل (إلزامي)</li>
                        <li><code>contact_person</code> - جهة الاتصال (اختياري)</li>
                        <li><code>contact_phone</code> - هاتف جهة الاتصال (اختياري)</li>
                        <li><code>contact_position</code> - منصب جهة الاتصال (اختياري)</li>
                        <li><code>email</code> - البريد الإلكتروني (اختياري)</li>
                        <li><code>phone</code> - الهاتف (اختياري)</li>
                        <li><code>mobile</code> - الجوال (اختياري)</li>
                        <li><code>address</code> - العنوان (اختياري)</li>
                        <li><code>city</code> - المدينة (اختياري)</li>
                        <li><code>state</code> - المنطقة (اختياري)</li>
                        <li><code>country</code> - البلد (اختياري)</li>
                        <li><code>postal_code</code> - الرمز البريدي (اختياري)</li>
                        <li><code>tax_number</code> - الرقم الضريبي (اختياري)</li>
                        <li><code>notes</code> - ملاحظات (اختياري)</li>
                        <li><code>type</code> - النوع (اختياري، واحد من: individual, company, government)</li>
                        <li><code>status</code> - الحالة (اختياري، واحد من: active, inactive, lead, prospect)</li>
                        <li><code>branch_id</code> - معرف الفرع (اختياري)</li>
                        <li><code>user_id</code> - معرف المستخدم المسؤول (اختياري)</li>
                    </ul>
                </li>
                <li>سيتم تجاهل العملاء المكررين (نفس الاسم والبريد الإلكتروني).</li>
                <li>إذا لم يتم تحديد فرع أو مستخدم، سيتم استخدام الفرع والمستخدم الحاليين.</li>
            </ul>
        </div>

        <div class="alert alert-warning">
            <h5><i class="bi bi-exclamation-triangle"></i> ملاحظة هامة:</h5>
            <p>يجب التأكد من صحة معرفات الفروع والمستخدمين قبل الاستيراد. يمكنك الاطلاع على قائمة الفروع والمستخدمين من خلال الروابط التالية:</p>
            <ul>
                <li><a href="{{ route('branches.index') }}" target="_blank">قائمة الفروع</a></li>
                <li><a href="{{ route('users.index') }}" target="_blank">قائمة المستخدمين</a></li>
            </ul>
        </div>

        <form action="{{ route('customers.import') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-3">
                <label for="file" class="form-label">ملف Excel</label>
                <input type="file" class="form-control @error('file') is-invalid @enderror" id="file" name="file" required>
                @error('file')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>

            <div class="mb-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-file-earmark-arrow-up"></i> استيراد
                </button>
            </div>
        </form>

        <div class="mt-4">
            <h5>نماذج ملفات الاستيراد</h5>
            <p>يمكنك تحميل نموذج ملف للاستيراد من خلال الروابط التالية:</p>
            <div class="d-flex gap-2">
                <a href="{{ asset('templates/customers_import_template.csv') }}" class="btn btn-success">
                    <i class="bi bi-download"></i> تحميل نموذج CSV
                </a>
                <a href="{{ asset('templates/customers_import_template.xlsx') }}" class="btn btn-primary">
                    <i class="bi bi-file-earmark-excel"></i> تحميل نموذج Excel
                </a>
            </div>
        </div>
    </div>
</div>
@endsection