@extends('layouts.modern')

@section('title', 'إضافة عميل جديد')

@section('header', 'إضافة عميل جديد')

@push('styles')
<style>
    .card {
        border-radius: 10px;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 2px solid #4e73df;
    }
    .form-label {
        font-weight: 600;
    }
    .section-title {
        position: relative;
        padding-right: 15px;
        margin-bottom: 20px;
        color: #3a3a3a;
        font-size: 1.1rem;
    }
    .section-title:before {
        content: "";
        position: absolute;
        right: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 5px;
        height: 20px;
        background-color: #4e73df;
        border-radius: 5px;
    }
    .customer-type-btn {
        transition: all 0.3s;
        border-radius: 20px;
        padding: 5px 15px;
    }
    .customer-type-btn:hover {
        transform: translateY(-2px);
    }
    .form-control, .form-select {
        border-radius: 5px;
        padding: 10px 15px;
        border: 1px solid #d1d3e2;
    }
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
    .btn-submit {
        border-radius: 5px;
        padding: 10px 25px;
        font-weight: 600;
        transition: all 0.3s;
    }
    .btn-submit:hover {
        transform: translateY(-2px);
    }
    .status-info {
        border-right: 3px solid #4e73df;
        padding: 10px;
        background-color: #f8f9fa;
        border-radius: 5px;
    }
</style>
@endpush

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">بيانات العميل</h6>
        <div class="btn-group" role="group">
            <button type="button" class="btn btn-success btn-sm customer-type-btn" id="btn-active-customer">عميل نشط</button>
            <button type="button" class="btn btn-warning btn-sm customer-type-btn" id="btn-lead-customer">عميل محتمل</button>
            <button type="button" class="btn btn-info btn-sm customer-type-btn" id="btn-prospect-customer">عميل متوقع</button>
        </div>
    </div>
    <div class="card-body">
        <form action="{{ route('customers.store') }}" method="POST">
            @csrf
            
            <div class="alert alert-info" id="customer-type-info" style="display: none;">
                <strong>ملاحظة:</strong> <span id="customer-type-message"></span>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">اسم العميل <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name') }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="type" class="form-label">نوع العميل <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">اختر النوع</option>
                            @foreach($types as $type)
                                <option value="{{ $type }}" {{ old('type') == $type ? 'selected' : '' }}>
                                    @if($type == 'individual')
                                        فرد
                                    @elseif($type == 'company')
                                        شركة
                                    @elseif($type == 'government')
                                        جهة حكومية
                                    @else
                                        {{ ucfirst($type) }}
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email') }}">
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="phone" class="form-label">رقم الهاتف</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone') }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="branch_id" class="form-label">الفرع <span class="text-danger">*</span></label>
                        <select class="form-select @error('branch_id') is-invalid @enderror" id="branch_id" name="branch_id" required>
                            <option value="">اختر الفرع</option>
                            @foreach($branches as $branch)
                                <option value="{{ $branch->id }}" {{ old('branch_id') == $branch->id ? 'selected' : '' }}>
                                    {{ $branch->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('branch_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="user_id" class="form-label">مسؤول الحساب <span class="text-danger">*</span></label>
                        <select class="form-select @error('user_id') is-invalid @enderror" id="user_id" name="user_id" required>
                            <option value="">اختر المسؤول</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : (auth()->id() == $user->id ? 'selected' : '') }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('user_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="status" class="form-label">حالة العميل <span class="text-danger">*</span></label>
                        <select class="form-select @error('status') is-invalid @enderror" id="status" name="status" required>
                            <option value="">اختر الحالة</option>
                            @foreach($statuses as $status)
                                <option value="{{ $status }}" {{ old('status', 'active') == $status ? 'selected' : '' }}>
                                    @if($status == 'active')
                                        عميل نشط
                                    @elseif($status == 'inactive')
                                        عميل غير نشط
                                    @elseif($status == 'lead')
                                        عميل محتمل
                                    @elseif($status == 'prospect')
                                        عميل متوقع
                                    @else
                                        {{ ucfirst($status) }}
                                    @endif
                                </option>
                            @endforeach
                        </select>
                        <div class="status-info mt-2">
                            <small class="form-text text-muted" id="status-help">
                                <span class="text-warning fw-bold">عميل محتمل:</span> عميل في مرحلة التواصل الأولي.<br>
                                <span class="text-info fw-bold">عميل متوقع:</span> عميل في مرحلة متقدمة من المفاوضات.<br>
                                <span class="text-success fw-bold">عميل نشط:</span> عميل حقيقي تم التعاقد معه.
                            </small>
                        </div>
                        @error('status')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="tax_number" class="form-label">الرقم الضريبي</label>
                        <input type="text" class="form-control @error('tax_number') is-invalid @enderror" id="tax_number" name="tax_number" value="{{ old('tax_number') }}">
                        @error('tax_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <h6 class="section-title mt-5 mb-4">معلومات جهة الاتصال</h6>
            
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="contact_person" class="form-label">اسم جهة الاتصال</label>
                        <input type="text" class="form-control @error('contact_person') is-invalid @enderror" id="contact_person" name="contact_person" value="{{ old('contact_person') }}">
                        @error('contact_person')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="contact_phone" class="form-label">رقم هاتف جهة الاتصال</label>
                        <input type="text" class="form-control @error('contact_phone') is-invalid @enderror" id="contact_phone" name="contact_phone" value="{{ old('contact_phone') }}">
                        @error('contact_phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="contact_position" class="form-label">المنصب الوظيفي</label>
                        <input type="text" class="form-control @error('contact_position') is-invalid @enderror" id="contact_position" name="contact_position" value="{{ old('contact_position') }}">
                        @error('contact_position')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <h6 class="section-title mt-5 mb-4">معلومات العنوان</h6>
            
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="address" class="form-label">العنوان</label>
                        <input type="text" class="form-control @error('address') is-invalid @enderror" id="address" name="address" value="{{ old('address') }}">
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="city" class="form-label">المدينة</label>
                        <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city') }}">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="state" class="form-label">المنطقة/المحافظة</label>
                        <input type="text" class="form-control @error('state') is-invalid @enderror" id="state" name="state" value="{{ old('state') }}">
                        @error('state')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="postal_code" class="form-label">الرمز البريدي</label>
                        <input type="text" class="form-control @error('postal_code') is-invalid @enderror" id="postal_code" name="postal_code" value="{{ old('postal_code') }}">
                        @error('postal_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="country" class="form-label">الدولة</label>
                        <input type="text" class="form-control @error('country') is-invalid @enderror" id="country" name="country" value="{{ old('country') }}">
                        @error('country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between mt-5">
                <a href="{{ route('customers.index') }}" class="btn btn-secondary">إلغاء</a>
                <button type="submit" class="btn btn-primary btn-submit">إضافة العميل</button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تعريف رسائل توضيحية لكل نوع من العملاء
        const customerTypeMessages = {
            'active': 'أنت تقوم بإضافة عميل نشط (عميل حقيقي تم التعاقد معه). تأكد من إدخال جميع البيانات المطلوبة.',
            'lead': 'أنت تقوم بإضافة عميل محتمل (في مرحلة التواصل الأولي). يمكنك إضافة بيانات أساسية فقط وتحديثها لاحقاً.',
            'prospect': 'أنت تقوم بإضافة عميل متوقع (في مرحلة متقدمة من المفاوضات). تأكد من إضافة بيانات التواصل الكاملة.'
        };

        // تحديث الرسالة التوضيحية عند تغيير حالة العميل
        function updateCustomerTypeInfo(status) {
            if (customerTypeMessages[status]) {
                $('#customer-type-message').text(customerTypeMessages[status]);
                $('#customer-type-info').show();
            } else {
                $('#customer-type-info').hide();
            }
        }

        // تحديث الرسالة عند تغيير حالة العميل يدوياً
        $('#status').change(function() {
            updateCustomerTypeInfo($(this).val());
        });

        // تحديث الرسالة عند تحميل الصفحة إذا كانت هناك قيمة محددة مسبقاً
        if ($('#status').val()) {
            updateCustomerTypeInfo($('#status').val());
        }

        // أزرار الاختيار السريع لنوع العميل
        $('#btn-active-customer').click(function() {
            $('#status').val('active').trigger('change');
        });

        $('#btn-lead-customer').click(function() {
            $('#status').val('lead').trigger('change');
        });

        $('#btn-prospect-customer').click(function() {
            $('#status').val('prospect').trigger('change');
        });
    });
</script>
@endpush