@extends('layouts.app')

@section('title', 'تفاصيل الاستبيان')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل الاستبيان: {{ $survey->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-surveys.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('customer-surveys.edit', $survey->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الاستبيان</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">العنوان</th>
                                            <td>{{ $survey->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $survey->description ?? 'لا يوجد وصف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البدء</th>
                                            <td>{{ $survey->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $survey->end_date ? $survey->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($survey->status == 'active')
                                                    <span class="badge bg-success">نشط</span>
                                                @elseif($survey->status == 'completed')
                                                    <span class="badge bg-info">مكتمل</span>
                                                @elseif($survey->status == 'draft')
                                                    <span class="badge bg-warning">مسودة</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>عدد الردود</th>
                                            <td>{{ $survey->total_responses }}</td>
                                        </tr>
                                        <tr>
                                            <th>متوسط التقييم</th>
                                            <td>{{ $survey->average_rating }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $survey->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الأسئلة</h5>
                                </div>
                                <div class="card-body">
                                    @if($survey->questions)
                                        @php
                                            $questions = json_decode($survey->questions, true);
                                        @endphp
                                        @if(is_array($questions) && count($questions) > 0)
                                            <div class="list-group">
                                                @foreach($questions as $index => $question)
                                                    <div class="list-group-item">
                                                        <h5 class="mb-1">السؤال {{ $index + 1 }}: {{ $question['text'] ?? '' }}</h5>
                                                        <p class="mb-1">
                                                            <strong>النوع:</strong>
                                                            @if($question['type'] == 'text')
                                                                نص
                                                            @elseif($question['type'] == 'rating')
                                                                تقييم
                                                            @elseif($question['type'] == 'choice')
                                                                اختيار متعدد
                                                            @endif
                                                        </p>
                                                        @if(isset($question['type']) && $question['type'] == 'choice' && isset($question['options']))
                                                            <p class="mb-1">
                                                                <strong>الخيارات:</strong>
                                                                {{ $question['options'] }}
                                                            </p>
                                                        @endif
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="alert alert-info">
                                                لا توجد أسئلة محددة.
                                            </div>
                                        @endif
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد أسئلة محددة.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الردود على الاستبيان</h5>
                                </div>
                                <div class="card-body">
                                    @if($survey->survey_responses && $survey->survey_responses->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>العميل</th>
                                                        <th>التقييم</th>
                                                        <th>تاريخ الرد</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($survey->survey_responses as $response)
                                                        <tr>
                                                            <td>{{ $response->id }}</td>
                                                            <td>{{ $response->customer->name ?? 'غير محدد' }}</td>
                                                            <td>{{ $response->rating ?? 'غير محدد' }}</td>
                                                            <td>{{ $response->created_at->format('Y-m-d H:i') }}</td>
                                                            <td>
                                                                <a href="{{ route('survey-responses.show', $response->id) }}" class="btn btn-info btn-sm">
                                                                    <i class="fas fa-eye"></i> عرض التفاصيل
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد ردود على هذا الاستبيان حتى الآن.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection