@extends('layouts.app')

@section('title', 'استبيانات العملاء')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">استبيانات العملاء</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-surveys.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة استبيان جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <form action="{{ route('customer-surveys.index') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <select name="status" class="form-control">
                                    <option value="">جميع الحالات</option>
                                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">تصفية</button>
                        </form>
                    </div>

                    @if($surveys->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>الحالة</th>
                                    <th>عدد الردود</th>
                                    <th>متوسط التقييم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($surveys as $survey)
                                <tr>
                                    <td>{{ $survey->id }}</td>
                                    <td>{{ $survey->title }}</td>
                                    <td>{{ $survey->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $survey->end_date ? $survey->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>
                                        @if($survey->status == 'active')
                                            <span class="badge bg-success">نشط</span>
                                        @elseif($survey->status == 'completed')
                                            <span class="badge bg-info">مكتمل</span>
                                        @elseif($survey->status == 'draft')
                                            <span class="badge bg-warning">مسودة</span>
                                        @endif
                                    </td>
                                    <td>{{ $survey->total_responses }}</td>
                                    <td>{{ $survey->average_rating }}</td>
                                    <td>
                                        <a href="{{ route('customer-surveys.show', $survey->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('customer-surveys.edit', $survey->id) }}" class="btn btn-primary btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('customer-surveys.destroy', $survey->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا الاستبيان؟')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $surveys->appends(request()->query())->links() }}
                    </div>
                    @else
                    <div class="alert alert-info">
                        لا توجد استبيانات للعرض.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection