@extends('layouts.app')

@section('title', 'إضافة استبيان جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة استبيان جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-surveys.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('customer-surveys.store') }}" method="POST">
                        @csrf
                        
                        <div class="form-group">
                            <label for="title">عنوان الاستبيان <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="title" class="form-control @error('title') is-invalid @enderror" value="{{ old('title') }}" required>
                            @error('title')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="description">وصف الاستبيان</label>
                            <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البدء <span class="text-danger">*</span></label>
                                    <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date', date('Y-m-d')) }}" required>
                                    @error('start_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="end_date">تاريخ الانتهاء</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date') }}">
                                    @error('end_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="status">الحالة <span class="text-danger">*</span></label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                <option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>نشط</option>
                                <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                            </select>
                            @error('status')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="questions">الأسئلة</label>
                            <div class="card">
                                <div class="card-body">
                                    <div id="questions-container">
                                        <div class="question-item mb-3 p-3 border rounded">
                                            <div class="form-group">
                                                <label>السؤال 1 <span class="text-danger">*</span></label>
                                                <input type="text" name="questions[0][text]" class="form-control" required>
                                            </div>
                                            <div class="form-group">
                                                <label>نوع السؤال</label>
                                                <select name="questions[0][type]" class="form-control question-type">
                                                    <option value="text">نص</option>
                                                    <option value="rating">تقييم</option>
                                                    <option value="choice">اختيار متعدد</option>
                                                </select>
                                            </div>
                                            <div class="options-container d-none">
                                                <div class="form-group">
                                                    <label>الخيارات (افصل بين الخيارات بفاصلة)</label>
                                                    <input type="text" name="questions[0][options]" class="form-control" placeholder="الخيار 1، الخيار 2، الخيار 3">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" id="add-question" class="btn btn-success btn-sm">
                                        <i class="fas fa-plus"></i> إضافة سؤال
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        let questionCount = 1;
        
        // إضافة سؤال جديد
        $('#add-question').click(function() {
            const newQuestion = `
                <div class="question-item mb-3 p-3 border rounded">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5>السؤال ${questionCount + 1}</h5>
                        <button type="button" class="btn btn-danger btn-sm remove-question">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                    <div class="form-group">
                        <label>نص السؤال <span class="text-danger">*</span></label>
                        <input type="text" name="questions[${questionCount}][text]" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>نوع السؤال</label>
                        <select name="questions[${questionCount}][type]" class="form-control question-type">
                            <option value="text">نص</option>
                            <option value="rating">تقييم</option>
                            <option value="choice">اختيار متعدد</option>
                        </select>
                    </div>
                    <div class="options-container d-none">
                        <div class="form-group">
                            <label>الخيارات (افصل بين الخيارات بفاصلة)</label>
                            <input type="text" name="questions[${questionCount}][options]" class="form-control" placeholder="الخيار 1، الخيار 2، الخيار 3">
                        </div>
                    </div>
                </div>
            `;
            
            $('#questions-container').append(newQuestion);
            questionCount++;
        });
        
        // حذف سؤال
        $(document).on('click', '.remove-question', function() {
            $(this).closest('.question-item').remove();
        });
        
        // إظهار/إخفاء خيارات السؤال حسب النوع
        $(document).on('change', '.question-type', function() {
            const optionsContainer = $(this).closest('.question-item').find('.options-container');
            if ($(this).val() === 'choice') {
                optionsContainer.removeClass('d-none');
            } else {
                optionsContainer.addClass('d-none');
            }
        });
    });
</script>
@endpush
@endsection