@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>كشف حساب العميل: {{ $statement['customer']['name'] }}</h4>
                    <div>
                        <a href="{{ route('customer-statements.export', $statement['customer']['id']) }}" class="btn btn-secondary" target="_blank">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </a>
                        <a href="{{ route('customer-statements.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات العميل</h5>
                            <p><strong>الاسم:</strong> {{ $statement['customer']['name'] }}</p>
                            <p><strong>العنوان:</strong> {{ $statement['customer']['address'] }}</p>
                            <p><strong>الهاتف:</strong> {{ $statement['customer']['phone'] }}</p>
                            <p><strong>البريد الإلكتروني:</strong> {{ $statement['customer']['email'] }}</p>
                        </div>
                        <div class="col-md-6">
                            <h5>معلومات الكشف</h5>
                            <p><strong>الفترة:</strong> {{ $statement['period']['start_date'] }} إلى {{ $statement['period']['end_date'] }}</p>
                            <p><strong>الرصيد الافتتاحي:</strong> {{ number_format($statement['opening_balance'], 2) }}</p>
                            <p><strong>الرصيد الختامي:</strong> {{ number_format($statement['closing_balance'], 2) }}</p>
                            <p><strong>إجمالي الفواتير:</strong> {{ number_format($statement['summary']['total_invoiced'], 2) }}</p>
                            <p><strong>إجمالي المدفوعات:</strong> {{ number_format($statement['summary']['total_paid'], 2) }}</p>
                        </div>
                    </div>

                    <h5 class="mt-4 mb-3">المعاملات</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="transactions-table">
                            <thead>
                                <tr>
                                    <th>التاريخ</th>
                                    <th>النوع</th>
                                    <th>الوصف</th>
                                    <th>المرجع</th>
                                    <th>مدين</th>
                                    <th>دائن</th>
                                    <th>الرصيد</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($statement['transactions'] as $transaction)
                                    <tr>
                                        <td>{{ $transaction['date'] }}</td>
                                        <td>
                                            @if($transaction['type'] == 'opening_balance')
                                                <span class="badge bg-secondary">رصيد افتتاحي</span>
                                            @elseif($transaction['type'] == 'invoice')
                                                <span class="badge bg-primary">فاتورة</span>
                                            @elseif($transaction['type'] == 'payment')
                                                <span class="badge bg-success">دفعة</span>
                                            @elseif($transaction['type'] == 'journal_entry')
                                                <span class="badge bg-warning">قيد محاسبي</span>
                                            @endif
                                        </td>
                                        <td>{{ $transaction['description'] }}</td>
                                        <td>{{ $transaction['reference'] }}</td>
                                        <td class="text-danger">{{ $transaction['debit'] > 0 ? number_format($transaction['debit'], 2) : '' }}</td>
                                        <td class="text-success">{{ $transaction['credit'] > 0 ? number_format($transaction['credit'], 2) : '' }}</td>
                                        <td class="{{ $transaction['balance'] >= 0 ? 'text-danger' : 'text-success' }}">
                                            {{ number_format(abs($transaction['balance']), 2) }}
                                            {{ $transaction['balance'] >= 0 ? 'مدين' : 'دائن' }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="table-dark">
                                    <td colspan="4" class="text-right"><strong>الإجمالي:</strong></td>
                                    <td class="text-danger"><strong>{{ number_format($statement['summary']['total_invoiced'], 2) }}</strong></td>
                                    <td class="text-success"><strong>{{ number_format($statement['summary']['total_paid'], 2) }}</strong></td>
                                    <td class="{{ $statement['summary']['balance_due'] >= 0 ? 'text-danger' : 'text-success' }}">
                                        <strong>
                                            {{ number_format(abs($statement['summary']['balance_due']), 2) }}
                                            {{ $statement['summary']['balance_due'] >= 0 ? 'مدين' : 'دائن' }}
                                        </strong>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    @push('scripts')
                    <script>
                        $(document).ready(function() {
                            $('#transactions-table').DataTable({
                                "language": {
                                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
                                },
                                "ordering": true,
                                "paging": true,
                                "searching": true,
                                "info": true,
                                "responsive": true,
                                "autoWidth": false
                            });
                        });
                    </script>
                    @endpush

                    <div class="mt-4">
                        <div class="alert alert-info">
                            <p><strong>ملاحظة:</strong> هذا الكشف يعكس المعاملات المالية للفترة المحددة فقط. الرصيد الختامي هو الرصيد المستحق حتى تاريخ {{ $statement['period']['end_date'] }}.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection