<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>كشف حساب العميل - {{ $statement['customer']['name'] }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
        }
        .customer-info {
            margin-bottom: 20px;
        }
        .statement-info {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .statement-info h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .summary {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .summary h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .notes {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>كشف حساب العميل</h1>
        <p>{{ $statement['customer']['name'] }}</p>
    </div>

    <div class="customer-info">
        <h3>معلومات العميل</h3>
        <p><strong>الاسم:</strong> {{ $statement['customer']['name'] }}</p>
        <p><strong>العنوان:</strong> {{ $statement['customer']['address'] }}</p>
        <p><strong>الهاتف:</strong> {{ $statement['customer']['phone'] }}</p>
        <p><strong>البريد الإلكتروني:</strong> {{ $statement['customer']['email'] }}</p>
    </div>

    <div class="statement-info">
        <h3>معلومات الكشف</h3>
        <p><strong>الفترة:</strong> {{ $statement['period']['start_date'] }} إلى {{ $statement['period']['end_date'] }}</p>
        <p><strong>الرصيد الافتتاحي:</strong> {{ number_format($statement['opening_balance'], 2) }}</p>
        <p><strong>الرصيد الختامي:</strong> {{ number_format($statement['closing_balance'], 2) }}</p>
    </div>

    <div class="summary">
        <h3>ملخص الحساب</h3>
        <p><strong>إجمالي الفواتير:</strong> {{ number_format($statement['summary']['total_invoiced'], 2) }}</p>
        <p><strong>إجمالي المدفوعات:</strong> {{ number_format($statement['summary']['total_paid'], 2) }}</p>
        <p><strong>الرصيد المستحق:</strong> {{ number_format($statement['summary']['balance_due'], 2) }}</p>
    </div>

    <h3>المعاملات</h3>
    <table>
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>النوع</th>
                <th>الوصف</th>
                <th>المرجع</th>
                <th>مدين</th>
                <th>دائن</th>
                <th>الرصيد</th>
            </tr>
        </thead>
        <tbody>
            @foreach($statement['transactions'] as $transaction)
                <tr>
                    <td>{{ $transaction['date'] }}</td>
                    <td>
                        @if($transaction['type'] == 'opening_balance')
                            رصيد افتتاحي
                        @elseif($transaction['type'] == 'invoice')
                            فاتورة
                        @elseif($transaction['type'] == 'payment')
                            دفعة
                        @endif
                    </td>
                    <td>{{ $transaction['description'] }}</td>
                    <td>{{ $transaction['reference'] }}</td>
                    <td>{{ $transaction['debit'] > 0 ? number_format($transaction['debit'], 2) : '' }}</td>
                    <td>{{ $transaction['credit'] > 0 ? number_format($transaction['credit'], 2) : '' }}</td>
                    <td>{{ number_format($transaction['balance'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="4" style="text-align: left;"><strong>الإجمالي:</strong></td>
                <td><strong>{{ number_format($statement['summary']['total_invoiced'], 2) }}</strong></td>
                <td><strong>{{ number_format($statement['summary']['total_paid'], 2) }}</strong></td>
                <td><strong>{{ number_format($statement['summary']['balance_due'], 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="notes">
        <h3>ملاحظات</h3>
        <p>هذا الكشف يعكس المعاملات المالية للفترة المحددة فقط. الرصيد الختامي هو الرصيد المستحق حتى تاريخ {{ $statement['period']['end_date'] }}.</p>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا الكشف بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>