@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>كشوف حساب العملاء</h4>
                    <div>
                        <a href="{{ route('customer-statements.generate-form') }}" class="btn btn-primary">إنشاء كشف حساب جديد</a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="customers-table">
                            <thead>
                                <tr>
                                    <th>اسم العميل</th>
                                    <th>رقم الهاتف</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>عدد الفواتير</th>
                                    <th>إجمالي المبالغ</th>
                                    <th>المبالغ المدفوعة</th>
                                    <th>المبالغ المستحقة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($customers as $customer)
                                    <tr>
                                        <td>{{ $customer->name }}</td>
                                        <td>{{ $customer->phone }}</td>
                                        <td>{{ $customer->email }}</td>
                                        <td>{{ $customer->invoices_count }}</td>
                                        <td class="text-danger">{{ number_format($customer->total_amount, 2) }}</td>
                                        <td class="text-success">{{ number_format($customer->paid_amount, 2) }}</td>
                                        <td class="{{ $customer->due_amount > 0 ? 'text-danger' : 'text-success' }}">
                                            {{ number_format(abs($customer->due_amount), 2) }}
                                            {{ $customer->due_amount > 0 ? 'مدين' : 'دائن' }}
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('customer-statements.generate-form', ['customer_id' => $customer->id]) }}" class="btn btn-primary btn-sm" title="إنشاء كشف حساب">
                                                    <i class="fas fa-file-invoice"></i>
                                                </a>
                                                <a href="{{ route('customer-statements.export', $customer->id) }}" class="btn btn-secondary btn-sm" title="تصدير PDF" target="_blank">
                                                    <i class="fas fa-file-pdf"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا يوجد عملاء</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    @push('scripts')
                    <script>
                        $(document).ready(function() {
                            $('#customers-table').DataTable({
                                "language": {
                                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
                                },
                                "ordering": true,
                                "paging": true,
                                "searching": true,
                                "info": true,
                                "responsive": true,
                                "autoWidth": false
                            });
                        });
                    </script>
                    @endpush
                </div>
            </div>
        </div>
    </div>
</div>
@endsection