@extends('layouts.app')

@section('title', 'تفاصيل المكافأة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل المكافأة</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-rewards.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>العميل:</label>
                                <p>
                                    @if($reward->customer)
                                        <a href="{{ route('customers.show', $reward->customer->id) }}">
                                            {{ $reward->customer->name }}
                                        </a>
                                    @else
                                        غير محدد
                                    @endif
                                </p>
                            </div>
                            
                            <div class="form-group">
                                <label>نوع المكافأة:</label>
                                <p>{{ $reward->reward_type }}</p>
                            </div>
                            
                            <div class="form-group">
                                <label>القيمة:</label>
                                <p>{{ $reward->value }}</p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ الإنشاء:</label>
                                <p>{{ $reward->created_at->format('Y-m-d') }}</p>
                            </div>
                            
                            <div class="form-group">
                                <label>تاريخ الانتهاء:</label>
                                <p>{{ $reward->expiry_date ? $reward->expiry_date->format('Y-m-d') : 'غير محدد' }}</p>
                            </div>
                            
                            <div class="form-group">
                                <label>الحالة:</label>
                                <p>
                                    @if($reward->status == 'pending')
                                        <span class="badge bg-warning">قيد الانتظار</span>
                                    @elseif($reward->status == 'approved')
                                        <span class="badge bg-success">تمت الموافقة</span>
                                    @elseif($reward->status == 'redeemed')
                                        <span class="badge bg-info">تم الاستبدال</span>
                                    @elseif($reward->status == 'expired')
                                        <span class="badge bg-secondary">منتهية الصلاحية</span>
                                    @elseif($reward->status == 'cancelled')
                                        <span class="badge bg-danger">ملغاة</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>الوصف:</label>
                                <p>{{ $reward->description ?: 'لا يوجد وصف' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <a href="{{ route('customer-rewards.edit', $reward->id) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            
                            @if($reward->status == 'pending' || $reward->status == 'approved')
                                <form action="{{ route('customer-rewards.update', $reward->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="status" value="redeemed">
                                    <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من استبدال هذه المكافأة؟')">
                                        <i class="fas fa-check"></i> استبدال المكافأة
                                    </button>
                                </form>
                            @endif
                            
                            <form action="{{ route('customer-rewards.destroy', $reward->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه المكافأة؟')">
                                    <i class="fas fa-trash"></i> حذف
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection