@extends('layouts.app')

@section('title', 'مكافآت العملاء')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مكافآت العملاء</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-rewards.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة مكافأة جديدة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <form action="{{ route('customer-rewards.index') }}" method="GET" class="form-inline">
                            <div class="form-group mr-2">
                                <select name="status" class="form-control">
                                    <option value="">جميع الحالات</option>
                                    <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                    <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>تمت الموافقة</option>
                                    <option value="redeemed" {{ request('status') == 'redeemed' ? 'selected' : '' }}>تم الاستبدال</option>
                                    <option value="expired" {{ request('status') == 'expired' ? 'selected' : '' }}>منتهية الصلاحية</option>
                                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">تصفية</button>
                        </form>
                    </div>

                    @if($rewards->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>نوع المكافأة</th>
                                    <th>القيمة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($rewards as $reward)
                                <tr>
                                    <td>{{ $reward->id }}</td>
                                    <td>
                                        @if($reward->customer)
                                            <a href="{{ route('customers.show', $reward->customer->id) }}">
                                                {{ $reward->customer->name }}
                                            </a>
                                        @else
                                            غير محدد
                                        @endif
                                    </td>
                                    <td>{{ $reward->reward_type }}</td>
                                    <td>{{ $reward->value }}</td>
                                    <td>{{ $reward->created_at->format('Y-m-d') }}</td>
                                    <td>{{ $reward->expiry_date ? $reward->expiry_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>
                                        @if($reward->status == 'pending')
                                            <span class="badge bg-warning">قيد الانتظار</span>
                                        @elseif($reward->status == 'approved')
                                            <span class="badge bg-success">تمت الموافقة</span>
                                        @elseif($reward->status == 'redeemed')
                                            <span class="badge bg-info">تم الاستبدال</span>
                                        @elseif($reward->status == 'expired')
                                            <span class="badge bg-secondary">منتهية الصلاحية</span>
                                        @elseif($reward->status == 'cancelled')
                                            <span class="badge bg-danger">ملغاة</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('customer-rewards.show', $reward->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('customer-rewards.edit', $reward->id) }}" class="btn btn-primary btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('customer-rewards.destroy', $reward->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذه المكافأة؟')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $rewards->appends(request()->query())->links() }}
                    </div>
                    @else
                    <div class="alert alert-info">
                        لا توجد مكافآت للعرض.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection