@extends('layouts.app')

@section('title', 'إضافة مكافأة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة مكافأة جديدة</h3>
                    <div class="card-tools">
                        <a href="{{ route('customer-rewards.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('customer-rewards.store') }}" method="POST">
                        @csrf
                        
                        <div class="form-group">
                            <label for="customer_id">العميل</label>
                            <select name="customer_id" id="customer_id" class="form-control select2 @error('customer_id') is-invalid @enderror" required>
                                <option value="">اختر العميل</option>
                                @foreach(\App\Models\Customer::where('company_id', auth()->user()->company_id)->get() as $customer)
                                    <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('customer_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="reward_type">نوع المكافأة</label>
                            <select name="reward_type" id="reward_type" class="form-control @error('reward_type') is-invalid @enderror" required>
                                <option value="">اختر نوع المكافأة</option>
                                <option value="discount" {{ old('reward_type') == 'discount' ? 'selected' : '' }}>خصم</option>
                                <option value="free_service" {{ old('reward_type') == 'free_service' ? 'selected' : '' }}>خدمة مجانية</option>
                                <option value="gift" {{ old('reward_type') == 'gift' ? 'selected' : '' }}>هدية</option>
                                <option value="points" {{ old('reward_type') == 'points' ? 'selected' : '' }}>نقاط</option>
                                <option value="other" {{ old('reward_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                            </select>
                            @error('reward_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="value">القيمة</label>
                            <input type="text" name="value" id="value" class="form-control @error('value') is-invalid @enderror" value="{{ old('value') }}" required>
                            @error('value')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="description">الوصف</label>
                            <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="expiry_date">تاريخ الانتهاء</label>
                            <input type="date" name="expiry_date" id="expiry_date" class="form-control @error('expiry_date') is-invalid @enderror" value="{{ old('expiry_date') }}">
                            @error('expiry_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="status">الحالة</label>
                            <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                <option value="pending" {{ old('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                <option value="approved" {{ old('status') == 'approved' ? 'selected' : '' }}>تمت الموافقة</option>
                                <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                            </select>
                            @error('status')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">حفظ</button>
                            <a href="{{ route('customer-rewards.index') }}" class="btn btn-default">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(function() {
        $('.select2').select2();
    });
</script>
@endpush