@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل التفاعل</h5>
                    <div>
                        <a href="{{ route('customer-interactions.add-follow-up', $interaction->id) }}" class="btn btn-success">
                            <i class="fas fa-plus-circle"></i> إضافة متابعة
                        </a>
                        <a href="{{ route('customer-interactions.edit', $interaction->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('customer-interactions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">معلومات التفاعل</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم التفاعل</th>
                                            <td>{{ $interaction->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                <a href="{{ route('customers.show', $interaction->customer_id) }}">
                                                    {{ $interaction->customer->name }}
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نوع التفاعل</th>
                                            <td>
                                                @switch($interaction->type)
                                                    @case('call')
                                                        <span class="badge bg-primary">مكالمة</span>
                                                        @break
                                                    @case('meeting')
                                                        <span class="badge bg-success">اجتماع</span>
                                                        @break
                                                    @case('email')
                                                        <span class="badge bg-info">بريد إلكتروني</span>
                                                        @break
                                                    @case('note')
                                                        <span class="badge bg-secondary">ملاحظة</span>
                                                        @break
                                                    @case('task')
                                                        <span class="badge bg-warning">مهمة</span>
                                                        @break
                                                    @default
                                                        <span class="badge bg-dark">أخرى</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $interaction->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التفاعل</th>
                                            <td>{{ $interaction->interaction_date->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ المتابعة</th>
                                            <td>{{ $interaction->follow_up_date ? $interaction->follow_up_date->format('Y-m-d H:i') : 'لا يوجد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="mb-0">حالة التفاعل</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الحالة</th>
                                            <td>
                                                @switch($interaction->status)
                                                    @case('pending')
                                                        <span class="badge bg-warning">قيد الانتظار</span>
                                                        @break
                                                    @case('completed')
                                                        <span class="badge bg-success">مكتمل</span>
                                                        @break
                                                    @case('cancelled')
                                                        <span class="badge bg-danger">ملغي</span>
                                                        @break
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>النتيجة</th>
                                            <td>
                                                @switch($interaction->outcome)
                                                    @case('positive')
                                                        <span class="badge bg-success">إيجابي</span>
                                                        @break
                                                    @case('negative')
                                                        <span class="badge bg-danger">سلبي</span>
                                                        @break
                                                    @case('neutral')
                                                        <span class="badge bg-secondary">محايد</span>
                                                        @break
                                                    @case('pending')
                                                        <span class="badge bg-warning">قيد الانتظار</span>
                                                        @break
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تم بواسطة</th>
                                            <td>{{ $interaction->user->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $interaction->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $interaction->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0">تفاصيل التفاعل</h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-4">
                                        <h6>الوصف:</h6>
                                        <div class="p-3 bg-light rounded">
                                            {!! nl2br(e($interaction->description)) ?: 'لا يوجد وصف' !!}
                                        </div>
                                    </div>

                                    <div>
                                        <h6>ملاحظات:</h6>
                                        <div class="p-3 bg-light rounded">
                                            {!! nl2br(e($interaction->notes)) ?: 'لا توجد ملاحظات' !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- قسم متابعات التفاعل -->
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h6 class="mb-0">متابعات التفاعل</h6>
                                    <a href="{{ route('customer-interactions.add-follow-up', $interaction->id) }}" class="btn btn-sm btn-success">
                                        <i class="fas fa-plus-circle"></i> إضافة متابعة جديدة
                                    </a>
                                </div>
                                <div class="card-body">
                                    @if($interaction->followUps->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>تاريخ المتابعة</th>
                                                        <th>بواسطة</th>
                                                        <th>النتيجة</th>
                                                        <th>ملاحظات</th>
                                                        <th>موعد المتابعة التالية</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($interaction->followUps->sortByDesc('follow_up_date') as $index => $followUp)
                                                        <tr>
                                                            <td>{{ $index + 1 }}</td>
                                                            <td>{{ $followUp->follow_up_date->format('Y-m-d H:i') }}</td>
                                                            <td>{{ $followUp->user->name }}</td>
                                                            <td>
                                                                @switch($followUp->outcome)
                                                                    @case('positive')
                                                                        <span class="badge bg-success">إيجابي</span>
                                                                        @break
                                                                    @case('negative')
                                                                        <span class="badge bg-danger">سلبي</span>
                                                                        @break
                                                                    @case('neutral')
                                                                        <span class="badge bg-secondary">محايد</span>
                                                                        @break
                                                                    @case('pending')
                                                                        <span class="badge bg-warning">قيد الانتظار</span>
                                                                        @break
                                                                @endswitch
                                                            </td>
                                                            <td>{{ Str::limit($followUp->notes, 100) }}</td>
                                                            <td>{{ $followUp->next_follow_up_date ? $followUp->next_follow_up_date->format('Y-m-d H:i') : 'لا يوجد' }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد متابعات مسجلة لهذا التفاعل.
                                            <a href="{{ route('customer-interactions.add-follow-up', $interaction->id) }}" class="alert-link">إضافة متابعة جديدة</a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12 text-center">
                            <form action="{{ route('customer-interactions.destroy', $interaction->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا التفاعل؟')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash"></i> حذف التفاعل
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection