@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاعلات العملاء</h5>
                    <div>
                        <a href="{{ route('customer-interactions.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة تفاعل جديد
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>النوع</th>
                                    <th>العنوان</th>
                                    <th>تاريخ التفاعل</th>
                                    <th>تاريخ المتابعة</th>
                                    <th>الحالة</th>
                                    <th>النتيجة</th>
                                    <th>المستخدم</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($interactions as $interaction)
                                    <tr>
                                        <td>{{ $interaction->id }}</td>
                                        <td>
                                            <a href="{{ route('customers.show', $interaction->customer_id) }}">
                                                {{ $interaction->customer->name }}
                                            </a>
                                        </td>
                                        <td>
                                            @switch($interaction->type)
                                                @case('call')
                                                    <span class="badge bg-primary">مكالمة</span>
                                                    @break
                                                @case('meeting')
                                                    <span class="badge bg-success">اجتماع</span>
                                                    @break
                                                @case('email')
                                                    <span class="badge bg-info">بريد إلكتروني</span>
                                                    @break
                                                @case('note')
                                                    <span class="badge bg-secondary">ملاحظة</span>
                                                    @break
                                                @case('task')
                                                    <span class="badge bg-warning">مهمة</span>
                                                    @break
                                                @default
                                                    <span class="badge bg-dark">أخرى</span>
                                            @endswitch
                                        </td>
                                        <td>{{ $interaction->title }}</td>
                                        <td>{{ $interaction->interaction_date->format('Y-m-d H:i') }}</td>
                                        <td>{{ $interaction->follow_up_date ? $interaction->follow_up_date->format('Y-m-d H:i') : 'لا يوجد' }}</td>
                                        <td>
                                            @switch($interaction->status)
                                                @case('pending')
                                                    <span class="badge bg-warning">قيد الانتظار</span>
                                                    @break
                                                @case('completed')
                                                    <span class="badge bg-success">مكتمل</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>
                                            @switch($interaction->outcome)
                                                @case('positive')
                                                    <span class="badge bg-success">إيجابي</span>
                                                    @break
                                                @case('negative')
                                                    <span class="badge bg-danger">سلبي</span>
                                                    @break
                                                @case('neutral')
                                                    <span class="badge bg-secondary">محايد</span>
                                                    @break
                                                @case('pending')
                                                    <span class="badge bg-warning">قيد الانتظار</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>{{ $interaction->user->name }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('customer-interactions.edit', $interaction->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('customer-interactions.destroy', $interaction->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا التفاعل؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center">لا توجد تفاعلات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $interactions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection