@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تعديل التفاعل</h5>
                    <div>
                        <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> عرض التفاصيل
                        </a>
                        <a href="{{ route('customer-interactions.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form method="POST" action="{{ route('customer-interactions.update', $interaction->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                    <select class="form-control @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">-- اختر العميل --</option>
                                        @foreach($customers as $customerItem)
                                            <option value="{{ $customerItem->id }}" {{ (old('customer_id', $interaction->customer_id) == $customerItem->id) ? 'selected' : '' }}>
                                                {{ $customerItem->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">نوع التفاعل <span class="text-danger">*</span></label>
                                    <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                                        <option value="">-- اختر النوع --</option>
                                        <option value="call" {{ old('type', $interaction->type) == 'call' ? 'selected' : '' }}>مكالمة</option>
                                        <option value="meeting" {{ old('type', $interaction->type) == 'meeting' ? 'selected' : '' }}>اجتماع</option>
                                        <option value="email" {{ old('type', $interaction->type) == 'email' ? 'selected' : '' }}>بريد إلكتروني</option>
                                        <option value="note" {{ old('type', $interaction->type) == 'note' ? 'selected' : '' }}>ملاحظة</option>
                                        <option value="task" {{ old('type', $interaction->type) == 'task' ? 'selected' : '' }}>مهمة</option>
                                        <option value="other" {{ old('type', $interaction->type) == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="title">عنوان التفاعل <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title', $interaction->title) }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="description">وصف التفاعل</label>
                                    <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $interaction->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="interaction_date">تاريخ التفاعل <span class="text-danger">*</span></label>
                                    <input type="datetime-local" class="form-control @error('interaction_date') is-invalid @enderror" id="interaction_date" name="interaction_date" value="{{ old('interaction_date', $interaction->interaction_date->format('Y-m-d\TH:i')) }}" required>
                                    @error('interaction_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="follow_up_date">تاريخ المتابعة</label>
                                    <input type="datetime-local" class="form-control @error('follow_up_date') is-invalid @enderror" id="follow_up_date" name="follow_up_date" value="{{ old('follow_up_date', $interaction->follow_up_date ? $interaction->follow_up_date->format('Y-m-d\TH:i') : '') }}">
                                    @error('follow_up_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                        <option value="pending" {{ old('status', $interaction->status) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="completed" {{ old('status', $interaction->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="cancelled" {{ old('status', $interaction->status) == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="outcome">النتيجة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('outcome') is-invalid @enderror" id="outcome" name="outcome" required>
                                        <option value="pending" {{ old('outcome', $interaction->outcome) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="positive" {{ old('outcome', $interaction->outcome) == 'positive' ? 'selected' : '' }}>إيجابي</option>
                                        <option value="negative" {{ old('outcome', $interaction->outcome) == 'negative' ? 'selected' : '' }}>سلبي</option>
                                        <option value="neutral" {{ old('outcome', $interaction->outcome) == 'neutral' ? 'selected' : '' }}>محايد</option>
                                    </select>
                                    @error('outcome')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $interaction->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection