@extends('layouts.modern')

@section('title', 'إضافة متابعة جديدة للتفاعل')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة متابعة جديدة للتفاعل</h5>
                    <div>
                        <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتفاعل
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">معلومات التفاعل الأصلي</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>العميل:</label>
                                        <p>{{ $interaction->customer->name }}</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>نوع التفاعل:</label>
                                        <p>
                                            @if($interaction->type == 'call')
                                                <span class="badge badge-info">مكالمة هاتفية</span>
                                            @elseif($interaction->type == 'meeting')
                                                <span class="badge badge-primary">اجتماع</span>
                                            @elseif($interaction->type == 'email')
                                                <span class="badge badge-secondary">بريد إلكتروني</span>
                                            @elseif($interaction->type == 'note')
                                                <span class="badge badge-warning">ملاحظة</span>
                                            @elseif($interaction->type == 'task')
                                                <span class="badge badge-success">مهمة</span>
                                            @else
                                                <span class="badge badge-dark">أخرى</span>
                                            @endif
                                            {{ $interaction->title }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>وصف التفاعل:</label>
                                        <p>{{ $interaction->description }}</p>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>تاريخ التفاعل:</label>
                                        <p>{{ $interaction->interaction_date->format('Y-m-d H:i') }}</p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>الحالة:</label>
                                        <p>
                                            @if($interaction->status == 'pending')
                                                <span class="badge badge-warning">معلق</span>
                                            @elseif($interaction->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                            @else
                                                <span class="badge badge-danger">ملغي</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>النتيجة:</label>
                                        <p>
                                            @if($interaction->outcome == 'positive')
                                                <span class="badge badge-success">إيجابية</span>
                                            @elseif($interaction->outcome == 'negative')
                                                <span class="badge badge-danger">سلبية</span>
                                            @elseif($interaction->outcome == 'neutral')
                                                <span class="badge badge-secondary">محايدة</span>
                                            @else
                                                <span class="badge badge-warning">معلقة</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">إضافة متابعة جديدة</h3>
                        </div>
                        <form action="{{ route('customer-interactions.store-follow-up', $interaction->id) }}" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="follow_up_date">تاريخ المتابعة <span class="text-danger">*</span></label>
                                            <input type="datetime-local" name="follow_up_date" id="follow_up_date" class="form-control @error('follow_up_date') is-invalid @enderror" value="{{ old('follow_up_date', now()->format('Y-m-d\TH:i')) }}" required>
                                            @error('follow_up_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="outcome">نتيجة المتابعة <span class="text-danger">*</span></label>
                                            <select name="outcome" id="outcome" class="form-control @error('outcome') is-invalid @enderror" required>
                                                <option value="positive" {{ old('outcome') == 'positive' ? 'selected' : '' }}>إيجابية</option>
                                                <option value="negative" {{ old('outcome') == 'negative' ? 'selected' : '' }}>سلبية</option>
                                                <option value="neutral" {{ old('outcome') == 'neutral' ? 'selected' : '' }}>محايدة</option>
                                                <option value="pending" {{ old('outcome') == 'pending' ? 'selected' : '' }}>معلقة</option>
                                            </select>
                                            @error('outcome')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="notes">ملاحظات المتابعة <span class="text-danger">*</span></label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="4" required>{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="next_follow_up_date">موعد المتابعة التالية</label>
                                    <input type="datetime-local" name="next_follow_up_date" id="next_follow_up_date" class="form-control @error('next_follow_up_date') is-invalid @enderror" value="{{ old('next_follow_up_date') }}">
                                    @error('next_follow_up_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-check mb-3">
                                    <input type="checkbox" name="update_interaction_status" id="update_interaction_status" class="form-check-input" value="1" {{ old('update_interaction_status') ? 'checked' : '' }}>
                                    <label for="update_interaction_status" class="form-check-label">تحديث حالة التفاعل</label>
                                </div>

                                <div class="form-group" id="status_group" style="display: none;">
                                    <label for="interaction_status">حالة التفاعل الجديدة</label>
                                    <select name="interaction_status" id="interaction_status" class="form-control">
                                        <option value="pending" {{ old('interaction_status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                        <option value="completed" {{ old('interaction_status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="cancelled" {{ old('interaction_status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>

                                <div class="form-check mb-3">
                                    <input type="checkbox" name="update_interaction_outcome" id="update_interaction_outcome" class="form-check-input" value="1" {{ old('update_interaction_outcome') ? 'checked' : '' }}>
                                    <label for="update_interaction_outcome" class="form-check-label">تحديث نتيجة التفاعل الأصلي بنفس نتيجة المتابعة</label>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">حفظ المتابعة</button>
                                <a href="{{ route('customer-interactions.show', $interaction->id) }}" class="btn btn-secondary">إلغاء</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const updateStatusCheckbox = document.getElementById('update_interaction_status');
        const statusGroup = document.getElementById('status_group');
        
        function toggleStatusGroup() {
            if (updateStatusCheckbox.checked) {
                statusGroup.style.display = 'block';
            } else {
                statusGroup.style.display = 'none';
            }
        }
        
        updateStatusCheckbox.addEventListener('change', toggleStatusGroup);
        
        // تنفيذ الدالة عند تحميل الصفحة للتأكد من الحالة الأولية
        toggleStatusGroup();
    });
</script>
@endpush