@extends('layouts.modern')

@section('title', 'تفاصيل الشركة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل الشركة: {{ $company->name }}</h3>
                    <div>
                        <a href="{{ route('company_management.edit', $company->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('company_management.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    @endif

                    <div class="row">
                        <!-- معلومات الشركة الأساسية -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات الشركة الأساسية</h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center mb-4">
                                        @if($company->logo)
                                        <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }}" class="img-fluid" style="max-height: 150px;">
                                        @else
                                        <div class="alert alert-secondary">
                                            لا يوجد شعار للشركة
                                        </div>
                                        @endif
                                    </div>
                                    
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">اسم الشركة</th>
                                            <td>{{ $company->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم الشركة (بالإنجليزية)</th>
                                            <td>{{ $company->name_en ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم السجل التجاري</th>
                                            <td>{{ $company->cr_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الضريبي</th>
                                            <td>{{ $company->vat_number ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>حالة الشركة</th>
                                            <td>
                                                @if($company->is_active)
                                                <span class="badge badge-success">نشط</span>
                                                @else
                                                <span class="badge badge-danger">غير نشط</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>خطة الاشتراك</th>
                                            <td>
                                                @switch($company->subscription_plan)
                                                    @case('basic')
                                                        <span class="badge badge-info">أساسية</span>
                                                        @break
                                                    @case('standard')
                                                        <span class="badge badge-primary">قياسية</span>
                                                        @break
                                                    @case('premium')
                                                        <span class="badge badge-success">متميزة</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $company->subscription_plan }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ انتهاء الاشتراك</th>
                                            <td>
                                                @if($company->subscription_ends_at)
                                                    {{ $company->subscription_ends_at->format('Y-m-d') }}
                                                    @if($company->subscription_ends_at->isPast())
                                                        <span class="badge badge-danger">منتهي</span>
                                                    @elseif($company->subscription_ends_at->diffInDays(now()) < 30)
                                                        <span class="badge badge-warning">ينتهي قريباً</span>
                                                    @else
                                                        <span class="badge badge-success">نشط</span>
                                                    @endif
                                                @else
                                                    غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <!-- معلومات الاتصال -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">معلومات الاتصال</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">البريد الإلكتروني</th>
                                            <td>{{ $company->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $company->phone ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>رقم الجوال</th>
                                            <td>{{ $company->mobile ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الموقع الإلكتروني</th>
                                            <td>
                                                @if($company->website)
                                                <a href="{{ $company->website }}" target="_blank">{{ $company->website }}</a>
                                                @else
                                                غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $company->address ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>العنوان (بالإنجليزية)</th>
                                            <td>{{ $company->address_en ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المدينة</th>
                                            <td>{{ $company->city ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المنطقة/المحافظة</th>
                                            <td>{{ $company->state ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الدولة</th>
                                            <td>{{ $company->country ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرمز البريدي</th>
                                            <td>{{ $company->postal_code ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <!-- الإعدادات المالية -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">الإعدادات المالية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 40%">العملة</th>
                                            <td>
                                                @switch($company->currency)
                                                    @case('SAR')
                                                        ريال سعودي (SAR)
                                                        @break
                                                    @case('USD')
                                                        دولار أمريكي (USD)
                                                        @break
                                                    @case('EUR')
                                                        يورو (EUR)
                                                        @break
                                                    @case('AED')
                                                        درهم إماراتي (AED)
                                                        @break
                                                    @case('KWD')
                                                        دينار كويتي (KWD)
                                                        @break
                                                    @case('BHD')
                                                        دينار بحريني (BHD)
                                                        @break
                                                    @case('QAR')
                                                        ريال قطري (QAR)
                                                        @break
                                                    @case('OMR')
                                                        ريال عماني (OMR)
                                                        @break
                                                    @default
                                                        {{ $company->currency }}
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نسبة الضريبة</th>
                                            <td>{{ $company->tax_rate }}%</td>
                                        </tr>
                                        <tr>
                                            <th>نسبة ضريبة القيمة المضافة</th>
                                            <td>{{ $company->vat_rate ?? '15.00' }}%</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الضريبي</th>
                                            <td>{{ $company->tax_number ?? 'غير محدد' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <!-- إحصائيات الشركة -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">إحصائيات الشركة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-primary text-white">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['branches_count'] }}</h3>
                                                    <p class="mb-0">الفروع</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-info text-white">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['users_count'] }}</h3>
                                                    <p class="mb-0">المستخدمين</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-success text-white">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['customers_count'] }}</h3>
                                                    <p class="mb-0">العملاء</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-warning text-dark">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['elevators_count'] }}</h3>
                                                    <p class="mb-0">المصاعد</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-danger text-white">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['contracts_count'] }}</h3>
                                                    <p class="mb-0">عقود الصيانة</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <div class="card bg-secondary text-white">
                                                <div class="card-body text-center">
                                                    <h3>{{ $statistics['invoices_count'] }}</h3>
                                                    <p class="mb-0">الفواتير</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if($company->notes)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    {{ $company->notes }}
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection