@extends('layouts.modern')

@section('title', 'إدارة الشركات')

@section('styles')
<style>
    /* تحسين تنسيق الجدول */
    .table-custom {
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
    }
    
    .table-custom thead {
        background-color: #4e73df;
        color: white;
    }
    
    .table-custom th {
        font-weight: 600;
        padding: 15px;
        border-bottom: none;
    }
    
    .table-custom td {
        padding: 12px 15px;
        vertical-align: middle;
    }
    
    /* تحسين أزرار الإجراءات */
    .action-btn {
        padding: 6px 12px;
        margin: 0 2px;
        border-radius: 4px;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        transition: all 0.3s;
    }
    
    .action-btn i {
        margin-left: 5px;
    }
    
    .btn-view {
        background-color: #36b9cc;
        border-color: #36b9cc;
        color: white;
    }
    
    .btn-view:hover {
        background-color: #2c9faf;
        border-color: #2c9faf;
        color: white;
    }
    
    .btn-edit {
        background-color: #f6c23e;
        border-color: #f6c23e;
        color: #2e2f37;
    }
    
    .btn-edit:hover {
        background-color: #e0b137;
        border-color: #e0b137;
        color: #2e2f37;
    }
    
    .btn-delete {
        background-color: #e74a3b;
        border-color: #e74a3b;
        color: white;
    }
    
    .btn-delete:hover {
        background-color: #d52a1a;
        border-color: #d52a1a;
        color: white;
    }
    
    /* تحسين شكل البادجات */
    .status-badge {
        padding: 6px 12px;
        border-radius: 30px;
        font-weight: 500;
        font-size: 0.85rem;
    }
    
    .badge-active {
        background-color: #1cc88a;
        color: white;
    }
    
    .badge-inactive {
        background-color: #e74a3b;
        color: white;
    }
    
    .badge-no-logo {
        background-color: #858796;
        color: white;
        padding: 5px 10px;
    }
    
    /* تحسين شكل الشعار */
    .company-logo {
        width: 60px;
        height: 60px;
        object-fit: contain;
        border-radius: 5px;
        border: 1px solid #e3e6f0;
        padding: 3px;
    }
    
    /* تحسين شكل زر الإضافة */
    .btn-add-company {
        background-color: #4e73df;
        color: white;
        padding: 8px 16px;
        border-radius: 5px;
        font-weight: 600;
        transition: all 0.3s;
    }
    
    .btn-add-company:hover {
        background-color: #2e59d9;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
    .btn-add-company i {
        margin-left: 5px;
    }
    
    /* تحسين شكل البطاقة */
    .card-custom {
        border: none;
        border-radius: 10px;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }
    
    .card-header-custom {
        background-color: #f8f9fc;
        border-bottom: 1px solid #e3e6f0;
        padding: 1.25rem;
        border-top-left-radius: 10px !important;
        border-top-right-radius: 10px !important;
    }
    
    .card-title-custom {
        color: #5a5c69;
        font-weight: 700;
        font-size: 1.2rem;
        margin-bottom: 0;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-custom">
                <div class="card-header card-header-custom d-flex justify-content-between align-items-center">
                    <h3 class="card-title card-title-custom">
                        <i class="bi bi-building me-2"></i>
                        إدارة الشركات
                    </h3>
                    <a href="{{ route('company_management.create') }}" class="btn btn-add-company">
                        <i class="bi bi-plus-circle"></i>
                        إضافة شركة جديدة
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-custom table-hover">
                            <thead>
                                <tr>
                                    <th>الشعار</th>
                                    <th>اسم الشركة</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>الهاتف</th>
                                    <th>المدينة</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($companies as $company)
                                <tr>
                                    <td class="text-center">
                                        @if($company->logo)
                                        <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }}" class="company-logo">
                                        @else
                                        <span class="badge badge-no-logo">
                                            <i class="bi bi-image me-1"></i>
                                            لا يوجد شعار
                                        </span>
                                        @endif
                                    </td>
                                    <td class="fw-bold">{{ $company->name }}</td>
                                    <td>
                                        <a href="mailto:{{ $company->email }}" class="text-decoration-none">
                                            <i class="bi bi-envelope me-1"></i>
                                            {{ $company->email }}
                                        </a>
                                    </td>
                                    <td>
                                        <a href="tel:{{ $company->phone }}" class="text-decoration-none">
                                            <i class="bi bi-telephone me-1"></i>
                                            {{ $company->phone }}
                                        </a>
                                    </td>
                                    <td>
                                        <i class="bi bi-geo-alt me-1"></i>
                                        {{ $company->city }}
                                    </td>
                                    <td>
                                        @if($company->is_active)
                                        <span class="status-badge badge-active">
                                            <i class="bi bi-check-circle me-1"></i>
                                            نشط
                                        </span>
                                        @else
                                        <span class="status-badge badge-inactive">
                                            <i class="bi bi-x-circle me-1"></i>
                                            غير نشط
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex">
                                            <a href="{{ route('company_management.show', $company->id) }}" class="btn action-btn btn-view">
                                                <i class="bi bi-eye"></i>
                                                عرض
                                            </a>
                                            <a href="{{ route('company_management.edit', $company->id) }}" class="btn action-btn btn-edit">
                                                <i class="bi bi-pencil"></i>
                                                تعديل
                                            </a>
                                            <form action="{{ route('company_management.destroy', $company->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه الشركة؟ هذا الإجراء لا يمكن التراجع عنه.');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn action-btn btn-delete">
                                                    <i class="bi bi-trash"></i>
                                                    حذف
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center py-4">
                                        <div class="d-flex flex-column align-items-center">
                                            <i class="bi bi-building-x fs-1 text-muted mb-2"></i>
                                            <p class="fs-5 text-muted">لا توجد شركات مسجلة</p>
                                            <a href="{{ route('company_management.create') }}" class="btn btn-primary mt-2">
                                                <i class="bi bi-plus-circle me-1"></i>
                                                إضافة شركة جديدة
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $companies->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection