@extends('layouts.modern')

@section('title', $company->name)

@section('header', $company->name)

@section('content')
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card shadow h-100">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">معلومات الشركة</h6>
                <a href="{{ route('companies.edit', $company->id) }}" class="btn btn-primary btn-sm">
                    <i class="bi bi-pencil"></i> تعديل
                </a>
            </div>
            <div class="card-body">
                <div class="text-center mb-4">
                    @if($company->logo)
                        <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }} Logo" class="img-fluid mb-3" style="max-height: 100px;">
                    @else
                        <div class="bg-light p-3 mb-3 rounded">
                            <i class="bi bi-building text-secondary" style="font-size: 3rem;"></i>
                        </div>
                    @endif
                    <h5>{{ $company->name }}</h5>
                    <p class="text-muted">
                        @if($company->is_active)
                            <span class="badge bg-success">نشط</span>
                        @else
                            <span class="badge bg-danger">غير نشط</span>
                        @endif
                        <span class="badge bg-info">
                            @if($company->subscription_plan == 'basic')
                                أساسي
                            @elseif($company->subscription_plan == 'standard')
                                قياسي
                            @elseif($company->subscription_plan == 'premium')
                                متميز
                            @else
                                {{ $company->subscription_plan }}
                            @endif
                        </span>
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">معلومات الاتصال</h6>
                    <p class="mb-1"><i class="bi bi-envelope me-2"></i> {{ $company->email }}</p>
                    <p class="mb-1"><i class="bi bi-telephone me-2"></i> {{ $company->phone ?: 'غير محدد' }}</p>
                    <p class="mb-1"><i class="bi bi-phone me-2"></i> {{ $company->mobile ?: 'غير محدد' }}</p>
                    @if($company->website)
                    <p class="mb-1"><i class="bi bi-globe me-2"></i> <a href="{{ $company->website }}" target="_blank">{{ $company->website }}</a></p>
                    @endif
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">العنوان</h6>
                    <p class="mb-1">
                        {{ $company->address ?: 'غير محدد' }}<br>
                        @if($company->city || $company->state || $company->postal_code)
                            {{ $company->city }}{{ $company->city && $company->state ? '، ' : '' }}{{ $company->state }} {{ $company->postal_code }}<br>
                        @endif
                        {{ $company->country ?: '' }}
                    </p>
                </div>
                
                <div class="mb-3">
                    <h6 class="font-weight-bold">المعلومات المالية</h6>
                    <p class="mb-1"><strong>العملة:</strong> {{ $company->currency }}</p>
                    <p class="mb-1"><strong>نسبة الضريبة:</strong> {{ $company->tax_rate }}%</p>
                    <p class="mb-1"><strong>نسبة ضريبة القيمة المضافة:</strong> {{ $company->vat_rate }}%</p>
                    <p class="mb-1"><strong>الرقم الضريبي:</strong> {{ $company->tax_number ?: 'غير محدد' }}</p>
                    <p class="mb-1"><strong>رقم السجل التجاري:</strong> {{ $company->cr_number ?: 'غير محدد' }}</p>
                    <p class="mb-1"><strong>رقم ضريبة القيمة المضافة:</strong> {{ $company->vat_number ?: 'غير محدد' }}</p>
                </div>
                
                @if(auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->position == 'super_admin' || auth()->user()->email == 'manager3@manager3.com')
                <div class="mb-3">
                    <h6 class="font-weight-bold">معلومات النظام</h6>
                    <p class="mb-1"><strong>النطاق:</strong> {{ $company->domain ?: 'غير محدد' }}</p>
                    <p class="mb-1"><strong>بادئة قاعدة البيانات:</strong> {{ $company->database_prefix }}</p>
                    <p class="mb-1"><strong>تاريخ انتهاء الاشتراك:</strong> {{ $company->subscription_ends_at ? $company->subscription_ends_at->format('Y-m-d') : 'غير محدد' }}</p>
                    <p class="mb-1"><strong>المستخدم الرئيسي:</strong> {{ $company->primaryUser ? $company->primaryUser->name . ' (' . $company->primaryUser->email . ')' : 'غير محدد' }}</p>
                </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-8 mb-4">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">إحصائيات الشركة</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-primary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            الفروع</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['branches_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-building fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            المستخدمين</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['users_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-people fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            العملاء</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['customers_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-person-badge fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-warning shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            المصاعد</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['elevators_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-arrow-up-square fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-danger shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            العقود</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['contracts_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-file-earmark-text fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-secondary shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                            الفواتير</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $statistics['invoices_count'] }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-receipt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-4">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-between flex-wrap">
                            <a href="{{ route('branches.index') }}" class="btn btn-primary mb-2">
                                <i class="bi bi-building"></i> إدارة الفروع
                            </a>
                            <a href="{{ route('users.index') }}" class="btn btn-success mb-2">
                                <i class="bi bi-people"></i> إدارة المستخدمين
                            </a>
                            <a href="{{ route('customers.index') }}" class="btn btn-info mb-2">
                                <i class="bi bi-person-badge"></i> إدارة العملاء
                            </a>
                            <a href="{{ route('companies.financial-report', $company->id) }}" class="btn btn-warning mb-2">
                                <i class="bi bi-graph-up"></i> التقرير المالي
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- بطاقة الملاحظات -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">ملاحظات</h6>
            </div>
            <div class="card-body">
                <p>{{ $company->notes ?: 'لا توجد ملاحظات مضافة.' }}</p>
            </div>
        </div>
    </div>
</div>
@endsection