@extends('layouts.modern')

@section('title', 'الشركات')

@section('header', 'الشركات')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('قائمة الشركات') }}</span>
                    @if(auth()->user()->hasRole('super_admin') || auth()->user()->position == 'super_admin' || auth()->user()->email == 'manager3@manager3.com')
                    <a href="{{ route('companies.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> {{ __('إضافة شركة جديدة') }}
                    </a>
                    @endif
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    @if($companies->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('اسم الشركة') }}</th>
                                        <th>{{ __('البريد الإلكتروني') }}</th>
                                        <th>{{ __('رقم الهاتف') }}</th>
                                        <th>{{ __('الحالة') }}</th>
                                        <th>{{ __('نوع الاشتراك') }}</th>
                                        <th>{{ __('الإجراءات') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($companies as $index => $company)
                                        <tr>
                                            <td>{{ $index + 1 + ($companies->currentPage() - 1) * $companies->perPage() }}</td>
                                            <td>{{ $company->name }}</td>
                                            <td>{{ $company->email }}</td>
                                            <td>{{ $company->phone ?: 'غير محدد' }}</td>
                                            <td>
                                                @if($company->is_active)
                                                    <span class="badge bg-success">نشط</span>
                                                @else
                                                    <span class="badge bg-danger">غير نشط</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($company->subscription_plan == 'basic')
                                                    <span class="badge bg-secondary">أساسي</span>
                                                @elseif($company->subscription_plan == 'standard')
                                                    <span class="badge bg-primary">قياسي</span>
                                                @elseif($company->subscription_plan == 'premium')
                                                    <span class="badge bg-warning">متميز</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('companies.show', $company->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('companies.edit', $company->id) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @if(auth()->user()->hasRole('super_admin') || auth()->user()->position == 'super_admin' || auth()->user()->email == 'manager3@manager3.com')
                                                    <form action="{{ route('companies.destroy', $company->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه الشركة؟');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            {{ $companies->links() }}
                        </div>
                    @else
                        <div class="alert alert-info text-center">
                            {{ __('لا توجد شركات مسجلة حتى الآن') }}
                            @if(auth()->user()->hasRole('super_admin') || auth()->user()->position == 'super_admin' || auth()->user()->email == 'manager3@manager3.com')
                            <div class="mt-3">
                                <a href="{{ route('companies.create') }}" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> {{ __('إضافة شركة جديدة') }}
                                </a>
                            </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection