@extends('layouts.modern')

@section('title', 'إعداد الشركة لأول مرة')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white text-center">
                    <h3 class="mb-0">
                        <i class="fas fa-building me-2"></i>
                        مرحباً بك في نظام إدارة المصاعد
                    </h3>
                </div>
                <div class="card-body text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-info-circle text-info" style="font-size: 4rem;"></i>
                    </div>
                    
                    <h4 class="mb-4">لا توجد شركات مسجلة حتى الآن</h4>
                    
                    <p class="text-muted mb-4">
                        للبدء في استخدام النظام، يجب عليك إنشاء شركتك الأولى.
                        <br>
                        سيتم ربطك تلقائياً بالشركة ومنحك صلاحيات المدير.
                    </p>

                    <div class="alert alert-info mx-auto" style="max-width: 500px;">
                        <i class="fas fa-lightbulb me-2"></i>
                        <strong>ملاحظة:</strong> يمكنك إنشاء شركة واحدة فقط لأول مرة.
                    </div>

                    <div class="mt-5">
                        <a href="{{ route('companies.create') }}" class="btn btn-primary btn-lg px-5">
                            <i class="fas fa-plus-circle me-2"></i>
                            إنشاء شركة جديدة لأول مرة
                        </a>
                    </div>
                </div>
            </div>

            <!-- معلومات إضافية -->
            <div class="card mt-4 shadow">
                <div class="card-header bg-light">
                    <h5 class="mb-0">
                        <i class="fas fa-question-circle me-2"></i>
                        ماذا سيحدث بعد إنشاء الشركة؟
                    </h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled">
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            سيتم ربط حسابك بالشركة الجديدة تلقائياً
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            ستحصل على صلاحيات المدير للشركة
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            ستتمكن من إضافة الفروع والموظفين والعملاء
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            ستتمكن من إدارة المصاعد وعقود الصيانة
                        </li>
                        <li class="mb-3">
                            <i class="fas fa-check-circle text-success me-2"></i>
                            ستتمكن من إصدار الفواتير وإدارة المدفوعات
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .card {
        border-radius: 15px;
        border: none;
    }
    
    .card-header {
        border-radius: 15px 15px 0 0 !important;
        padding: 1.5rem;
    }
    
    .btn-lg {
        border-radius: 50px;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-lg:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 123, 255, 0.3);
    }
    
    .alert {
        border-radius: 10px;
    }
</style>
@endsection