@extends('layouts.modern')

@section('title', 'التقرير المالي - ' . $company->name)

@section('header', 'التقرير المالي للشركة: ' . $company->name)

@section('content')
<div class="row">
    <div class="col-md-12 mb-4">
        <div class="card shadow">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">ملخص التقرير المالي</h6>
                <div>
                    <a href="{{ route('companies.show', $company->id) }}" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-right"></i> العودة للشركة
                    </a>
                    <button class="btn btn-primary btn-sm" onclick="window.print()">
                        <i class="bi bi-printer"></i> طباعة التقرير
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h5>معلومات الشركة</h5>
                        <p class="mb-1"><strong>اسم الشركة:</strong> {{ $company->name }}</p>
                        <p class="mb-1"><strong>رقم السجل التجاري:</strong> {{ $company->cr_number ?: 'غير محدد' }}</p>
                        <p class="mb-1"><strong>رقم ضريبة القيمة المضافة:</strong> {{ $company->vat_number ?: 'غير محدد' }}</p>
                        <p class="mb-1"><strong>العملة:</strong> {{ $company->currency }}</p>
                    </div>
                    <div class="col-md-6 text-end">
                        <h5>الفترة</h5>
                        <p class="mb-1"><strong>من:</strong> {{ $startDate->format('Y-m-d') }}</p>
                        <p class="mb-1"><strong>إلى:</strong> {{ $endDate->format('Y-m-d') }}</p>
                        <p class="mb-1"><strong>تاريخ التقرير:</strong> {{ now()->format('Y-m-d') }}</p>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="card border-right-success h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            إجمالي الإيرادات</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalRevenue, 2) }} {{ $company->currency }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-cash-stack fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 mb-4">
                        <div class="card border-right-danger h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                            إجمالي المصروفات</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($totalExpenses, 2) }} {{ $company->currency }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-credit-card fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 mb-4">
                        <div class="card border-right-primary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            صافي الربح</div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($netProfit, 2) }} {{ $company->currency }}</div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="bi bi-graph-up fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-4">
                        <div class="card shadow h-100">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">الفواتير</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>الحالة</th>
                                                <th>العدد</th>
                                                <th>المبلغ</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>مدفوعة</td>
                                                <td>{{ $paidInvoicesCount }}</td>
                                                <td>{{ number_format($paidInvoicesAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr>
                                                <td>غير مدفوعة</td>
                                                <td>{{ $unpaidInvoicesCount }}</td>
                                                <td>{{ number_format($unpaidInvoicesAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr>
                                                <td>مدفوعة جزئياً</td>
                                                <td>{{ $partiallyPaidInvoicesCount }}</td>
                                                <td>{{ number_format($partiallyPaidInvoicesAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr class="table-primary">
                                                <td><strong>الإجمالي</strong></td>
                                                <td><strong>{{ $totalInvoicesCount }}</strong></td>
                                                <td><strong>{{ number_format($totalInvoicesAmount, 2) }} {{ $company->currency }}</strong></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 mb-4">
                        <div class="card shadow h-100">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">العقود</h6>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>الحالة</th>
                                                <th>العدد</th>
                                                <th>المبلغ</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>نشطة</td>
                                                <td>{{ $activeContractsCount }}</td>
                                                <td>{{ number_format($activeContractsAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr>
                                                <td>منتهية</td>
                                                <td>{{ $expiredContractsCount }}</td>
                                                <td>{{ number_format($expiredContractsAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr>
                                                <td>قريبة الانتهاء</td>
                                                <td>{{ $expiringContractsCount }}</td>
                                                <td>{{ number_format($expiringContractsAmount, 2) }} {{ $company->currency }}</td>
                                            </tr>
                                            <tr class="table-primary">
                                                <td><strong>الإجمالي</strong></td>
                                                <td><strong>{{ $totalContractsCount }}</strong></td>
                                                <td><strong>{{ number_format($totalContractsAmount, 2) }} {{ $company->currency }}</strong></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-4">
                        <div class="card shadow">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">الإيرادات الشهرية</h6>
                            </div>
                            <div class="card-body">
                                <div class="chart-area">
                                    <canvas id="monthlyRevenueChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات الإيرادات الشهرية
        var ctx = document.getElementById('monthlyRevenueChart').getContext('2d');
        var monthlyRevenueChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($monthlyRevenueLabels) !!},
                datasets: [{
                    label: 'الإيرادات الشهرية ({{ $company->currency }})',
                    data: {!! json_encode($monthlyRevenueData) !!},
                    backgroundColor: 'rgba(78, 115, 223, 0.5)',
                    borderColor: 'rgba(78, 115, 223, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString() + ' {{ $company->currency }}';
                            }
                        }
                    }
                },
                plugins: {
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.dataset.label + ': ' + context.parsed.y.toLocaleString() + ' {{ $company->currency }}';
                            }
                        }
                    }
                }
            }
        });
    });
</script>
@endsection