@extends('layouts.modern')

@section('title', 'تعديل الشركة')

@section('header', 'تعديل الشركة: ' . $company->name)

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">معلومات الشركة</h6>
        <a href="{{ route('companies.show', $company->id) }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-right"></i> العودة
        </a>
    </div>
    <div class="card-body">
        <form action="{{ route('companies.update', $company->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">اسم الشركة <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $company->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name_en" class="form-label">اسم الشركة (بالإنجليزية)</label>
                        <input type="text" class="form-control @error('name_en') is-invalid @enderror" id="name_en" name="name_en" value="{{ old('name_en', $company->name_en) }}">
                        @error('name_en')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="email" class="form-label">البريد الإلكتروني <span class="text-danger">*</span></label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $company->email) }}" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="website" class="form-label">الموقع الإلكتروني</label>
                        <input type="url" class="form-control @error('website') is-invalid @enderror" id="website" name="website" value="{{ old('website', $company->website) }}">
                        @error('website')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="phone" class="form-label">رقم الهاتف</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', $company->phone) }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="mobile" class="form-label">رقم الجوال</label>
                        <input type="text" class="form-control @error('mobile') is-invalid @enderror" id="mobile" name="mobile" value="{{ old('mobile', $company->mobile) }}">
                        @error('mobile')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="address" class="form-label">العنوان</label>
                        <textarea class="form-control @error('address') is-invalid @enderror" id="address" name="address" rows="3">{{ old('address', $company->address) }}</textarea>
                        @error('address')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="address_en" class="form-label">العنوان (بالإنجليزية)</label>
                        <textarea class="form-control @error('address_en') is-invalid @enderror" id="address_en" name="address_en" rows="3">{{ old('address_en', $company->address_en) }}</textarea>
                        @error('address_en')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="city" class="form-label">المدينة</label>
                        <input type="text" class="form-control @error('city') is-invalid @enderror" id="city" name="city" value="{{ old('city', $company->city) }}">
                        @error('city')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="state" class="form-label">المنطقة/المحافظة</label>
                        <input type="text" class="form-control @error('state') is-invalid @enderror" id="state" name="state" value="{{ old('state', $company->state) }}">
                        @error('state')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="country" class="form-label">الدولة</label>
                        <input type="text" class="form-control @error('country') is-invalid @enderror" id="country" name="country" value="{{ old('country', $company->country) }}">
                        @error('country')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="postal_code" class="form-label">الرمز البريدي</label>
                        <input type="text" class="form-control @error('postal_code') is-invalid @enderror" id="postal_code" name="postal_code" value="{{ old('postal_code', $company->postal_code) }}">
                        @error('postal_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <h5 class="mt-4 mb-3 text-primary">المعلومات المالية والتجارية</h5>
            
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="cr_number" class="form-label">رقم السجل التجاري</label>
                        <input type="text" class="form-control @error('cr_number') is-invalid @enderror" id="cr_number" name="cr_number" value="{{ old('cr_number', $company->cr_number) }}">
                        @error('cr_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="vat_number" class="form-label">رقم ضريبة القيمة المضافة</label>
                        <input type="text" class="form-control @error('vat_number') is-invalid @enderror" id="vat_number" name="vat_number" value="{{ old('vat_number', $company->vat_number) }}">
                        @error('vat_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="tax_number" class="form-label">الرقم الضريبي</label>
                        <input type="text" class="form-control @error('tax_number') is-invalid @enderror" id="tax_number" name="tax_number" value="{{ old('tax_number', $company->tax_number) }}">
                        @error('tax_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="currency" class="form-label">العملة <span class="text-danger">*</span></label>
                        <select class="form-select @error('currency') is-invalid @enderror" id="currency" name="currency" required>
                            <option value="SAR" {{ old('currency', $company->currency) == 'SAR' ? 'selected' : '' }}>ريال سعودي (SAR)</option>
                            <option value="USD" {{ old('currency', $company->currency) == 'USD' ? 'selected' : '' }}>دولار أمريكي (USD)</option>
                            <option value="EUR" {{ old('currency', $company->currency) == 'EUR' ? 'selected' : '' }}>يورو (EUR)</option>
                            <option value="GBP" {{ old('currency', $company->currency) == 'GBP' ? 'selected' : '' }}>جنيه إسترليني (GBP)</option>
                            <option value="AED" {{ old('currency', $company->currency) == 'AED' ? 'selected' : '' }}>درهم إماراتي (AED)</option>
                            <option value="KWD" {{ old('currency', $company->currency) == 'KWD' ? 'selected' : '' }}>دينار كويتي (KWD)</option>
                            <option value="BHD" {{ old('currency', $company->currency) == 'BHD' ? 'selected' : '' }}>دينار بحريني (BHD)</option>
                            <option value="QAR" {{ old('currency', $company->currency) == 'QAR' ? 'selected' : '' }}>ريال قطري (QAR)</option>
                        </select>
                        @error('currency')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="tax_rate" class="form-label">نسبة الضريبة (%) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" min="0" max="100" class="form-control @error('tax_rate') is-invalid @enderror" id="tax_rate" name="tax_rate" value="{{ old('tax_rate', $company->tax_rate) }}" required>
                        @error('tax_rate')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="vat_rate" class="form-label">نسبة ضريبة القيمة المضافة (%) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" min="0" max="100" class="form-control @error('vat_rate') is-invalid @enderror" id="vat_rate" name="vat_rate" value="{{ old('vat_rate', $company->vat_rate) }}" required>
                        @error('vat_rate')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="logo" class="form-label">شعار الشركة</label>
                        @if($company->logo)
                            <div class="mb-2">
                                <img src="{{ asset('storage/' . $company->logo) }}" alt="{{ $company->name }} Logo" class="img-thumbnail" style="max-height: 100px;">
                            </div>
                        @endif
                        <input type="file" class="form-control @error('logo') is-invalid @enderror" id="logo" name="logo">
                        <small class="form-text text-muted">قم بتحميل صورة شعار جديدة (JPEG, PNG, JPG, GIF). الحجم الأقصى: 2 ميجابايت</small>
                        @error('logo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            @if(auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin') || auth()->user()->position == 'super_admin' || auth()->user()->email == 'manager3@manager3.com')
            <h5 class="mt-4 mb-3 text-primary">معلومات النظام (للمشرف فقط)</h5>
            
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="primary_user_id" class="form-label">المستخدم الرئيسي</label>
                        <select class="form-select @error('primary_user_id') is-invalid @enderror" id="primary_user_id" name="primary_user_id">
                            <option value="">-- اختر المستخدم الرئيسي --</option>
                            @foreach($availableUsers as $user)
                                <option value="{{ $user->id }}" {{ old('primary_user_id', $company->primary_user_id) == $user->id ? 'selected' : '' }}>{{ $user->name }} ({{ $user->email }})</option>
                            @endforeach
                        </select>
                        @error('primary_user_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="domain" class="form-label">النطاق</label>
                        <input type="text" class="form-control @error('domain') is-invalid @enderror" id="domain" name="domain" value="{{ old('domain', $company->domain) }}">
                        @error('domain')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="subscription_plan" class="form-label">خطة الاشتراك</label>
                        <select class="form-select @error('subscription_plan') is-invalid @enderror" id="subscription_plan" name="subscription_plan">
                            <option value="basic" {{ old('subscription_plan', $company->subscription_plan) == 'basic' ? 'selected' : '' }}>أساسي</option>
                            <option value="standard" {{ old('subscription_plan', $company->subscription_plan) == 'standard' ? 'selected' : '' }}>قياسي</option>
                            <option value="premium" {{ old('subscription_plan', $company->subscription_plan) == 'premium' ? 'selected' : '' }}>متميز</option>
                        </select>
                        @error('subscription_plan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="subscription_ends_at" class="form-label">تاريخ انتهاء الاشتراك</label>
                        <input type="date" class="form-control @error('subscription_ends_at') is-invalid @enderror" id="subscription_ends_at" name="subscription_ends_at" value="{{ old('subscription_ends_at', $company->subscription_ends_at ? $company->subscription_ends_at->format('Y-m-d') : '') }}">
                        @error('subscription_ends_at')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $company->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                نشط
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            @endif
            
            <div class="row mb-3">
                <div class="col-md-12">
                    <div class="mb-3">
                        <label for="notes" class="form-label">ملاحظات</label>
                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $company->notes) }}</textarea>
                        @error('notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="{{ route('companies.show', $company->id) }}" class="btn btn-secondary">إلغاء</a>
                <button type="submit" class="btn btn-primary">تحديث الشركة</button>
            </div>
        </form>
    </div>
</div>
@endsection