@extends('layouts.app')

@section('title', 'View Civil Defense Termination Letter')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Civil Defense Termination Letter Details</h3>
                    <div class="card-tools">
                        <a href="{{ route('civil-defense.termination-letters.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                        <a href="{{ route('civil-defense.termination-letters.edit', $letter) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('civil-defense.termination-letters.print', $letter) }}" class="btn btn-primary btn-sm" target="_blank">
                            <i class="fas fa-print"></i> Print
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Termination Letter Information</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">ID</th>
                                            <td>{{ $letter->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>Termination Date</th>
                                            <td>{{ $letter->termination_date ? $letter->termination_date->format('Y-m-d') : 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Created By</th>
                                            <td>{{ $letter->createdBy->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Created At</th>
                                            <td>{{ $letter->created_at ? $letter->created_at->format('Y-m-d H:i') : 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Updated At</th>
                                            <td>{{ $letter->updated_at ? $letter->updated_at->format('Y-m-d H:i') : 'N/A' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Elevator Information</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">Serial Number</th>
                                            <td>{{ $letter->elevator->serial_number ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Type</th>
                                            <td>{{ $letter->elevator->elevatorType->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Model</th>
                                            <td>{{ $letter->elevator->elevatorModel->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td>
                                                @if($letter->elevator)
                                                    <span class="badge badge-{{ $letter->elevator->status == 'under_maintenance' ? 'warning' : 'success' }}">
                                                        {{ ucfirst(str_replace('_', ' ', $letter->elevator->status ?? 'N/A')) }}
                                                    </span>
                                                @else
                                                    N/A
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Installation Date</th>
                                            <td>{{ $letter->elevator && $letter->elevator->installation_date ? $letter->elevator->installation_date->format('Y-m-d') : 'N/A' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Customer Information</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 20%">Name</th>
                                            <td>{{ $letter->customer->name ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Phone</th>
                                            <td>{{ $letter->customer->phone ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td>{{ $letter->customer->email ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Address (Original)</th>
                                            <td>{{ $letter->customer->address ?? 'N/A' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Address (In Letter)</th>
                                            <td>{{ $letter->customer_address ?? 'N/A' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="btn-group">
                        <a href="{{ route('civil-defense.termination-letters.edit', $letter) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('civil-defense.termination-letters.print', $letter) }}" class="btn btn-primary" target="_blank">
                            <i class="fas fa-print"></i> Print
                        </a>
                        <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#deleteModal">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this termination letter?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <form action="{{ route('civil-defense.termination-letters.destroy', $letter) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection