<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Civil Defense Termination Letter</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 14px;
            line-height: 1.5;
        }
        .letter-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid #ddd;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 10px;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .company-info {
            font-size: 12px;
            margin-bottom: 5px;
        }
        .letter-title {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            margin: 20px 0;
            text-decoration: underline;
        }
        .date-section {
            text-align: left;
            margin-bottom: 20px;
        }
        .recipient-section {
            margin-bottom: 20px;
        }
        .content {
            margin-bottom: 30px;
            text-align: justify;
        }
        .signature-section {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }
        .signature-box {
            width: 45%;
        }
        .signature-line {
            border-top: 1px solid #000;
            margin-top: 50px;
            padding-top: 5px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        @media print {
            .print-button {
                display: none;
            }
            body {
                padding: 0;
            }
            .letter-container {
                border: none;
            }
        }
    </style>
</head>
<body>
    <button class="print-button" onclick="window.print()">Print</button>
    
    <div class="letter-container">
        <div class="header">
            @if($letter->company->logo)
                <img src="{{ asset('storage/' . $letter->company->logo) }}" alt="Company Logo" class="logo">
            @endif
            <div class="company-name">{{ $letter->company->name }}</div>
            <div class="company-info">{{ $letter->company->address }}</div>
            <div class="company-info">Phone: {{ $letter->company->phone }} | Email: {{ $letter->company->email }}</div>
        </div>
        
        <div class="letter-title">CIVIL DEFENSE TERMINATION LETTER</div>
        
        <div class="date-section">
            <p><strong>Date:</strong> {{ $letter->termination_date ? $letter->termination_date->format('F d, Y') : date('F d, Y') }}</p>
            <p><strong>Reference:</strong> CD-TL-{{ $letter->id }}-{{ $letter->created_at ? $letter->created_at->format('Ymd') : date('Ymd') }}</p>
        </div>
        
        <div class="recipient-section">
            <p><strong>To:</strong> Civil Defense Department</p>
            <p><strong>Subject:</strong> Termination of Maintenance for Elevator</p>
        </div>
        
        <div class="content">
            <p>Dear Sir/Madam,</p>
            
            <p>This letter serves as an official notification that our company, <strong>{{ $letter->company->name }}</strong>, is terminating the maintenance service for the following elevator:</p>
            
            <p>
                <strong>Elevator Serial Number:</strong> {{ $letter->elevator->serial_number ?? 'N/A' }}<br>
                <strong>Elevator Type:</strong> {{ $letter->elevator->elevatorType->name ?? 'N/A' }}<br>
                <strong>Elevator Model:</strong> {{ $letter->elevator->elevatorModel->name ?? 'N/A' }}<br>
                <strong>Installation Date:</strong> {{ $letter->elevator->installation_date ? $letter->elevator->installation_date->format('F d, Y') : 'N/A' }}
            </p>
            
            <p>
                <strong>Customer Information:</strong><br>
                <strong>Name:</strong> {{ $letter->customer->name ?? 'N/A' }}<br>
                <strong>Address:</strong> {{ $letter->customer_address ?? 'N/A' }}<br>
                <strong>Phone:</strong> {{ $letter->customer->phone ?? 'N/A' }}
            </p>
            
            <p>The maintenance service for this elevator is being terminated effective from the date of this letter. We hereby request that you update your records accordingly.</p>
            
            <p>Please note that our company will no longer be responsible for the maintenance, safety, or operation of this elevator after the termination date.</p>
            
            <p>If you require any additional information or have any questions regarding this termination, please do not hesitate to contact us.</p>
            
            <p>Thank you for your attention to this matter.</p>
        </div>
        
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line">Authorized Signature</div>
                <p>{{ $letter->createdBy->name ?? 'Authorized Representative' }}</p>
                <p>{{ $letter->company->name }}</p>
            </div>
            
            <div class="signature-box">
                <div class="signature-line">Company Stamp</div>
            </div>
        </div>
        
        <div class="footer">
            <p>This is an official document of {{ $letter->company->name }}. Generated on {{ date('F d, Y') }}.</p>
        </div>
    </div>
</body>
</html>