@extends('layouts.app')

@section('title', 'Civil Defense Termination Letters')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Civil Defense Termination Letters</h3>
                    <div class="card-tools">
                        <a href="{{ route('civil-defense.termination-letters.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Create New
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h3 class="card-title">Filters</h3>
                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('civil-defense.termination-letters.index') }}" method="GET">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="customer_id">Customer</label>
                                                    <select name="customer_id" id="customer_id" class="form-control select2">
                                                        <option value="">All Customers</option>
                                                        @foreach($customers as $customer)
                                                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                                                {{ $customer->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="elevator_id">Elevator</label>
                                                    <select name="elevator_id" id="elevator_id" class="form-control select2">
                                                        <option value="">All Elevators</option>
                                                        @foreach($elevators as $elevator)
                                                            <option value="{{ $elevator->id }}" {{ request('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                                {{ $elevator->serial_number }} - {{ $elevator->customer->name ?? 'N/A' }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="date_from">Date From</label>
                                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label for="date_to">Date To</label>
                                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12 text-right">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-search"></i> Filter
                                                </button>
                                                <a href="{{ route('civil-defense.termination-letters.index') }}" class="btn btn-default">
                                                    <i class="fas fa-redo"></i> Reset
                                                </a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Flash Messages -->
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            {{ session('success') }}
                        </div>
                    @endif

                    <!-- Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Elevator</th>
                                    <th>Customer</th>
                                    <th>Termination Date</th>
                                    <th>Created By</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($letters as $letter)
                                    <tr>
                                        <td>{{ $letter->id }}</td>
                                        <td>{{ $letter->elevator->serial_number ?? 'N/A' }}</td>
                                        <td>{{ $letter->customer->name ?? 'N/A' }}</td>
                                        <td>{{ $letter->termination_date ? $letter->termination_date->format('Y-m-d') : 'N/A' }}</td>
                                        <td>{{ $letter->createdBy->name ?? 'N/A' }}</td>
                                        <td>{{ $letter->created_at ? $letter->created_at->format('Y-m-d H:i') : 'N/A' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('civil-defense.termination-letters.show', $letter) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('civil-defense.termination-letters.edit', $letter) }}" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <a href="{{ route('civil-defense.termination-letters.print', $letter) }}" class="btn btn-primary btn-sm" target="_blank">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $letter->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteModal{{ $letter->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $letter->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $letter->id }}">Confirm Delete</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            Are you sure you want to delete this termination letter?
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                            <form action="{{ route('civil-defense.termination-letters.destroy', $letter) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">Delete</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No termination letters found.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="mt-4">
                        {{ $letters->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        $('.select2').select2();
    });
</script>
@endsection