@extends('layouts.app')

@section('title', 'Edit Civil Defense Termination Letter')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Edit Civil Defense Termination Letter</h3>
                    <div class="card-tools">
                        <a href="{{ route('civil-defense.termination-letters.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-left"></i> Back to List
                        </a>
                        <a href="{{ route('civil-defense.termination-letters.show', $letter) }}" class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> View Details
                        </a>
                    </div>
                </div>
                <form action="{{ route('civil-defense.termination-letters.update', $letter) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">Elevator (Under Maintenance) <span class="text-danger">*</span></label>
                                    <select name="elevator_id" id="elevator_id" class="form-control select2 @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">Select Elevator</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ (old('elevator_id', $letter->elevator_id) == $elevator->id) ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }} - {{ $elevator->customer->name ?? 'N/A' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="termination_date">Termination Date <span class="text-danger">*</span></label>
                                    <input type="date" name="termination_date" id="termination_date" class="form-control @error('termination_date') is-invalid @enderror" value="{{ old('termination_date', $letter->termination_date ? $letter->termination_date->format('Y-m-d') : '') }}" required>
                                    @error('termination_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">Customer <span class="text-danger">*</span></label>
                                    <input type="hidden" name="customer_id" id="customer_id" value="{{ old('customer_id', $letter->customer_id) }}">
                                    <input type="text" id="customer_name" class="form-control" value="{{ $letter->customer->name ?? '' }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_phone">Customer Phone</label>
                                    <input type="text" id="customer_phone" class="form-control" value="{{ $letter->customer->phone ?? '' }}" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="customer_address">Customer Address <span class="text-danger">*</span></label>
                                    <textarea name="customer_address" id="customer_address" class="form-control @error('customer_address') is-invalid @enderror" rows="3" required>{{ old('customer_address', $letter->customer_address) }}</textarea>
                                    @error('customer_address')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update
                        </button>
                        <a href="{{ route('civil-defense.termination-letters.index') }}" class="btn btn-default">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        $('.select2').select2();

        // Get customer information when elevator is selected
        $('#elevator_id').on('change', function() {
            var elevatorId = $(this).val();
            if (elevatorId) {
                $.ajax({
                    url: "{{ route('civil-defense.get-customer-info') }}",
                    type: "GET",
                    data: { elevator_id: elevatorId },
                    success: function(response) {
                        $('#customer_id').val(response.customer_id);
                        $('#customer_name').val(response.customer_name);
                        $('#customer_phone').val(response.customer_phone);
                        
                        // Only update the address if it's empty or if the user hasn't modified it
                        if (!$('#customer_address').val() || $('#customer_address').val() == $('#customer_address').data('original')) {
                            $('#customer_address').val(response.customer_address);
                            $('#customer_address').data('original', response.customer_address);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error(error);
                        alert('Error fetching customer information. Please try again.');
                    }
                });
            } else {
                $('#customer_id').val('');
                $('#customer_name').val('');
                $('#customer_phone').val('');
                // Don't clear the address to preserve user edits
            }
        });

        // Store the original address for comparison
        $('#customer_address').data('original', $('#customer_address').val());
    });
</script>
@endsection