@extends('layouts.modern')

@section('title', 'التحقق من الصلاحيات')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">التحقق من الصلاحيات</div>

                <div class="card-body">
                    <h4>معلومات المستخدم</h4>
                    <ul>
                        <li><strong>الاسم:</strong> {{ Auth::user()->name }}</li>
                        <li><strong>البريد الإلكتروني:</strong> {{ Auth::user()->email }}</li>
                        <li><strong>مدير النظام:</strong> {{ Auth::user()->is_admin ? 'نعم' : 'لا' }}</li>
                    </ul>

                    <h4>الأدوار</h4>
                    <ul>
                        @foreach(Auth::user()->roles as $role)
                            <li>{{ $role->name }} ({{ $role->slug }})</li>
                        @endforeach
                    </ul>

                    <h4>الصلاحيات من خلال الأدوار</h4>
                    <ul>
                        @php
                            $rolePermissions = collect();
                            foreach(Auth::user()->roles as $role) {
                                foreach($role->permissions as $permission) {
                                    $rolePermissions->push($permission);
                                }
                            }
                            $rolePermissions = $rolePermissions->unique('id');
                        @endphp
                        
                        @foreach($rolePermissions as $permission)
                            <li>{{ $permission->name }} ({{ $permission->slug }})</li>
                        @endforeach
                    </ul>

                    <h4>الصلاحيات المباشرة</h4>
                    <ul>
                        @if(Auth::user()->directPermissions)
                            @foreach(Auth::user()->directPermissions as $userPerm)
                                <li>
                                    {{ $userPerm->permission->name }} ({{ $userPerm->permission->slug }})
                                    - {{ $userPerm->granted ? 'ممنوحة' : 'ممنوعة' }}
                                    @if($userPerm->expires_at)
                                        - تنتهي في {{ $userPerm->expires_at }}
                                    @endif
                                </li>
                            @endforeach
                        @else
                            <li>لا توجد صلاحيات مباشرة</li>
                        @endif
                    </ul>

                    <h4>التحقق من صلاحيات محددة</h4>
                    <ul>
                        <li>
                            <strong>manage_permissions:</strong>
                            {{ Auth::user()->hasPermissionTo('manage_permissions') ? 'نعم' : 'لا' }}
                        </li>
                        <li>
                            <strong>manage_roles:</strong>
                            {{ Auth::user()->hasPermissionTo('manage_roles') ? 'نعم' : 'لا' }}
                        </li>
                        <li>
                            <strong>manage_users:</strong>
                            {{ Auth::user()->hasPermissionTo('manage_users') ? 'نعم' : 'لا' }}
                        </li>
                        <li>
                            <strong>create_customers:</strong>
                            {{ Auth::user()->hasPermissionTo('create_customers') ? 'نعم' : 'لا' }}
                        </li>
                    </ul>

                    <h4>روابط مفيدة</h4>
                    <ul>
                        <li><a href="{{ route('permissions.index') }}">قائمة الصلاحيات</a></li>
                        <li><a href="{{ route('roles.index') }}">قائمة الأدوار</a></li>
                        <li><a href="{{ route('users.index') }}">قائمة المستخدمين</a></li>
                        <li><a href="{{ route('permissions.manage-users') }}">إدارة صلاحيات المستخدمين</a></li>
                        <li><a href="{{ route('roles.manage-users') }}">إدارة أدوار المستخدمين</a></li>
                        <li><a href="{{ route('temp.permissions.manage-users') }}" class="text-success font-weight-bold">إدارة صلاحيات المستخدمين (مسار مؤقت)</a></li>
                    </ul>
                    
                    <div class="alert alert-info mt-4">
                        <h5>ملاحظة هامة:</h5>
                        <p>إذا كنت تواجه مشكلة في الوصول إلى صفحة إدارة الصلاحيات، يمكنك استخدام المسار المؤقت:</p>
                        <ul>
                            <li><a href="{{ route('temp.permissions.manage-users') }}">{{ route('temp.permissions.manage-users') }}</a></li>
                        </ul>
                        <p>هذا المسار لا يتطلب صلاحية <code>manage_permissions</code> ويمكن استخدامه لإصلاح مشاكل الصلاحيات.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection