@extends('layouts.app')

@section('title', 'سحوبات الخزائن')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">سحوبات الخزائن</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-withdrawals.create') }}" class="btn btn-danger btn-sm">
                            <i class="fas fa-minus"></i> إضافة سحب جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('cash-withdrawals.index') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="cash_register_id">الخزينة</label>
                                    <select name="cash_register_id" id="cash_register_id" class="form-control">
                                        <option value="">كل الخزائن</option>
                                        @foreach($cashRegisters as $register)
                                            <option value="{{ $register->id }}" {{ request('cash_register_id') == $register->id ? 'selected' : '' }}>{{ $register->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> بحث
                                </button>
                                <a href="{{ route('cash-withdrawals.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> إعادة تعيين
                                </a>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>التاريخ</th>
                                    <th>الخزينة</th>
                                    <th>المبلغ</th>
                                    <th>الطرف المرتبط</th>
                                    <th>المستخدم</th>
                                    <th>الملاحظات</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $index => $transaction)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                                        <td>{{ $transaction->cashRegister->name }}</td>
                                        <td>{{ number_format($transaction->amount, 2) }} {{ $transaction->cashRegister->currency }}</td>
                                        <td>
                                            @if($transaction->party_name)
                                                {{ $transaction->party_name }}
                                                @if($transaction->party_type)
                                                    <small class="d-block text-muted">
                                                        @if($transaction->party_type == 'customer')
                                                            (عميل)
                                                        @elseif($transaction->party_type == 'supplier')
                                                            (مورد)
                                                        @elseif($transaction->party_type == 'employee')
                                                            (موظف)
                                                        @elseif($transaction->party_type == 'other')
                                                            (أخرى)
                                                        @endif
                                                    </small>
                                                @endif
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>{{ $transaction->user ? $transaction->user->name : 'غير محدد' }}</td>
                                        <td>{{ $transaction->notes ?? '-' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('cash-transactions.show', $transaction->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($transaction->created_at->diffInDays(now()) <= 1)
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteTransactionModal{{ $transaction->id }}" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                @endif
                                            </div>

                                            <!-- Modal Delete Transaction -->
                                            <div class="modal fade" id="deleteTransactionModal{{ $transaction->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteTransactionModalLabel" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteTransactionModalLabel">تأكيد حذف المعاملة</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف هذه المعاملة؟ سيتم استرجاع التغييرات في الرصيد.
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('cash-transactions.destroy', $transaction->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد سحوبات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $transactions->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection