@extends('layouts.app')

@section('title', 'سحب من الخزينة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">سحب من الخزينة: {{ $cashRegister->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-registers.show', $cashRegister->id) }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للخزينة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> الرصيد الحالي: <strong>{{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</strong>
                    </div>

                    <form action="{{ route('cash-transactions.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="cash_register_id" value="{{ $cashRegister->id }}">
                        <input type="hidden" name="type" value="withdrawal">

                        <div class="form-group">
                            <label for="amount">مبلغ السحب <span class="text-danger">*</span></label>
                            <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" step="0.01" min="0.01" max="{{ $cashRegister->current_balance }}" required>
                            @error('amount')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                            <small class="text-muted">الحد الأقصى للسحب هو {{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</small>
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="attachment">مرفق</label>
                            <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                            <small class="text-muted">يمكنك إرفاق ملف (صورة أو PDF) بحجم أقصى 2 ميجابايت</small>
                            @error('attachment')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-minus-circle"></i> سحب
                            </button>
                            <a href="{{ route('cash-registers.show', $cashRegister->id) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection