@extends('layouts.app')

@section('title', 'تحويل من الخزينة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تحويل من الخزينة: {{ $cashRegister->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-registers.show', $cashRegister->id) }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للخزينة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> الرصيد الحالي: <strong>{{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</strong>
                    </div>

                    @if($targetCashRegisters->isEmpty())
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i> لا توجد خزائن أخرى نشطة للتحويل إليها.
                        </div>
                    @else
                        <form action="{{ route('cash-transactions.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="cash_register_id" value="{{ $cashRegister->id }}">
                            <input type="hidden" name="type" value="transfer">

                            <div class="form-group">
                                <label for="related_cash_register_id">الخزينة المستلمة <span class="text-danger">*</span></label>
                                <select name="related_cash_register_id" id="related_cash_register_id" class="form-control @error('related_cash_register_id') is-invalid @enderror" required>
                                    <option value="">اختر الخزينة المستلمة</option>
                                    @foreach($targetCashRegisters as $targetRegister)
                                        <option value="{{ $targetRegister->id }}" {{ old('related_cash_register_id') == $targetRegister->id ? 'selected' : '' }}>
                                            {{ $targetRegister->name }} ({{ number_format($targetRegister->current_balance, 2) }} {{ $targetRegister->currency }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('related_cash_register_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="amount">مبلغ التحويل <span class="text-danger">*</span></label>
                                <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" step="0.01" min="0.01" max="{{ $cashRegister->current_balance }}" required>
                                @error('amount')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="text-muted">الحد الأقصى للتحويل هو {{ number_format($cashRegister->current_balance, 2) }} {{ $cashRegister->currency }}</small>
                            </div>

                            <div class="form-group">
                                <label for="notes">ملاحظات</label>
                                <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                @error('notes')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="attachment">مرفق</label>
                                <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                                <small class="text-muted">يمكنك إرفاق ملف (صورة أو PDF) بحجم أقصى 2 ميجابايت</small>
                                @error('attachment')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-exchange-alt"></i> تحويل
                                </button>
                                <a href="{{ route('cash-registers.show', $cashRegister->id) }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection