@extends('layouts.app')

@section('title', 'إيصال المعاملة النقدية')

@section('styles')
<style>
    .receipt-header {
        text-align: center;
        margin-bottom: 20px;
        padding-bottom: 15px;
        border-bottom: 2px dashed #ddd;
    }
    .receipt-title {
        font-size: 24px;
        font-weight: bold;
        margin-bottom: 5px;
        color: #3c8dbc;
    }
    .receipt-subtitle {
        font-size: 16px;
        color: #777;
    }
    .transaction-badge {
        font-size: 14px;
        padding: 8px 15px;
        border-radius: 20px;
        display: inline-block;
        margin-bottom: 10px;
    }
    .transaction-amount {
        font-size: 28px;
        font-weight: bold;
        color: #28a745;
        margin: 15px 0;
        text-align: center;
    }
    .transaction-withdrawal {
        color: #dc3545;
    }
    .transaction-transfer {
        color: #17a2b8;
    }
    .info-section {
        background-color: #f8f9fa;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    }
    .info-title {
        font-weight: bold;
        color: #495057;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid #dee2e6;
    }
    .info-row {
        display: flex;
        margin-bottom: 10px;
        align-items: center;
    }
    .info-label {
        font-weight: bold;
        width: 40%;
        color: #6c757d;
    }
    .info-value {
        width: 60%;
    }
    .action-buttons {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-top: 20px;
    }
    .action-button {
        padding: 8px 20px;
        border-radius: 5px;
        font-weight: bold;
        transition: all 0.3s;
    }
    .action-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .receipt-footer {
        text-align: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 2px dashed #ddd;
        color: #6c757d;
    }
    .attachment-preview {
        text-align: center;
        margin: 20px 0;
    }
    .attachment-preview img {
        max-width: 100%;
        max-height: 300px;
        border-radius: 5px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    }
    .print-button {
        position: absolute;
        top: 15px;
        left: 15px;
    }
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .receipt-footer {
            margin-top: 50px;
        }
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        @if($transaction->type == 'deposit')
                            <i class="fas fa-money-bill-wave text-success ml-2"></i> إيصال إيداع نقدي
                        @elseif($transaction->type == 'withdrawal')
                            <i class="fas fa-money-bill-wave text-danger ml-2"></i> إيصال سحب نقدي
                        @elseif($transaction->type == 'transfer')
                            <i class="fas fa-exchange-alt text-info ml-2"></i> إيصال تحويل نقدي
                        @endif
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-transactions.index') }}" class="btn btn-default btn-sm no-print">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        <button onclick="window.print()" class="btn btn-primary btn-sm print-button no-print">
                            <i class="fas fa-print"></i> طباعة الإيصال
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- بداية الإيصال -->
                    <div class="receipt-container">
                        <!-- رأس الإيصال -->
                        <div class="receipt-header">
                            <div class="receipt-title">
                                @if($transaction->type == 'deposit')
                                    إيصال إيداع نقدي
                                @elseif($transaction->type == 'withdrawal')
                                    إيصال سحب نقدي
                                @elseif($transaction->type == 'transfer')
                                    إيصال تحويل نقدي
                                @endif
                            </div>
                            <div class="receipt-subtitle">
                                رقم المعاملة: #{{ $transaction->id }} | تاريخ: {{ $transaction->created_at->format('Y-m-d') }}
                            </div>
                        </div>
                        
                        <!-- قسم المبلغ -->
                        <div class="text-center mb-4">
                            @if($transaction->type == 'deposit')
                                <span class="transaction-badge bg-success text-white">{{ $transaction->type_name }}</span>
                            @elseif($transaction->type == 'withdrawal')
                                <span class="transaction-badge bg-danger text-white">{{ $transaction->type_name }}</span>
                            @elseif($transaction->type == 'transfer')
                                <span class="transaction-badge bg-info text-white">{{ $transaction->type_name }}</span>
                            @endif
                            
                            <div class="transaction-amount {{ $transaction->type == 'withdrawal' ? 'transaction-withdrawal' : ($transaction->type == 'transfer' ? 'transaction-transfer' : '') }}">
                                {{ number_format($transaction->amount, 2) }} {{ $transaction->cashRegister->currency }}
                            </div>
                        </div>
                        
                        <!-- معلومات المعاملة -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-section">
                                    <h5 class="info-title"><i class="fas fa-info-circle ml-2"></i> معلومات المعاملة</h5>
                                    
                                    <div class="info-row">
                                        <div class="info-label">الوقت</div>
                                        <div class="info-value">{{ $transaction->created_at->format('H:i:s') }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">الخزينة</div>
                                        <div class="info-value">{{ $transaction->cashRegister->name }}</div>
                                    </div>
                                    
                                    @if($transaction->type == 'transfer')
                                    <div class="info-row">
                                        <div class="info-label">الخزينة المستلمة</div>
                                        <div class="info-value">{{ $transaction->relatedCashRegister ? $transaction->relatedCashRegister->name : 'غير محدد' }}</div>
                                    </div>
                                    @endif
                                    
                                    @if($transaction->type == 'deposit' || $transaction->type == 'withdrawal')
                                    <div class="info-row">
                                        <div class="info-label">اسم الطرف</div>
                                        <div class="info-value">{{ $transaction->party_name ?? 'غير محدد' }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">نوع الطرف</div>
                                        <div class="info-value">
                                            @if($transaction->party_type == 'customer')
                                                <span class="badge badge-info">عميل</span>
                                            @elseif($transaction->party_type == 'supplier')
                                                <span class="badge badge-warning">مورد</span>
                                            @elseif($transaction->party_type == 'employee')
                                                <span class="badge badge-secondary">موظف</span>
                                            @elseif($transaction->party_type == 'other')
                                                <span class="badge badge-dark">أخرى</span>
                                            @else
                                                غير محدد
                                            @endif
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="info-section">
                                    <h5 class="info-title"><i class="fas fa-user-circle ml-2"></i> معلومات إضافية</h5>
                                    
                                    <div class="info-row">
                                        <div class="info-label">المستخدم</div>
                                        <div class="info-value">{{ $transaction->user ? $transaction->user->name : 'غير محدد' }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">الشركة</div>
                                        <div class="info-value">{{ $transaction->company ? $transaction->company->name : 'غير محدد' }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">المرجع</div>
                                        <div class="info-value">{{ $transaction->reference_type ? $transaction->reference_type . ' #' . $transaction->reference_id : 'لا يوجد' }}</div>
                                    </div>
                                    
                                    <div class="info-row">
                                        <div class="info-label">الملاحظات</div>
                                        <div class="info-value">{{ $transaction->notes ?? 'لا توجد ملاحظات' }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- عرض المرفق إذا وجد -->
                        @if($transaction->attachment)
                        <div class="attachment-preview">
                            <h5 class="info-title text-center"><i class="fas fa-paperclip ml-2"></i> المرفق</h5>
                            @php
                                $fileExtension = pathinfo(storage_path('app/public/' . $transaction->attachment), PATHINFO_EXTENSION);
                                $isImage = in_array(strtolower($fileExtension), ['jpg', 'jpeg', 'png', 'gif']);
                            @endphp
                            
                            @if($isImage)
                                <img src="{{ asset('storage/' . $transaction->attachment) }}" alt="مرفق المعاملة" class="img-fluid">
                            @else
                                <a href="{{ asset('storage/' . $transaction->attachment) }}" target="_blank" class="btn btn-info">
                                    <i class="fas fa-file-{{ $fileExtension == 'pdf' ? 'pdf' : 'alt' }} ml-2"></i> عرض المرفق ({{ strtoupper($fileExtension) }})
                                </a>
                            @endif
                        </div>
                        @endif
                        
                        <!-- أزرار الإجراءات -->
                        <div class="action-buttons no-print">
                            @if($transaction->created_at->diffInDays(now()) <= 1)
                                <button type="button" class="btn btn-danger action-button" data-toggle="modal" data-target="#deleteTransactionModal">
                                    <i class="fas fa-trash ml-2"></i> حذف المعاملة
                                </button>
                            @endif
                            
                            <a href="{{ route('cash-registers.show', $transaction->cash_register_id) }}" class="btn btn-primary action-button">
                                <i class="fas fa-eye ml-2"></i> عرض الخزينة
                            </a>
                        </div>
                        
                        <!-- تذييل الإيصال -->
                        <div class="receipt-footer">
                            <p>تم إنشاء هذا الإيصال بواسطة نظام إدارة المصاعد</p>
                            <p>{{ now()->format('Y-m-d H:i:s') }}</p>
                        </div>
                    </div>

                    <!-- Modal Delete Transaction -->
                    <div class="modal fade" id="deleteTransactionModal" tabindex="-1" role="dialog" aria-labelledby="deleteTransactionModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="deleteTransactionModalLabel">تأكيد حذف المعاملة</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    هل أنت متأكد من حذف هذه المعاملة؟ سيتم استرجاع التغييرات في الرصيد.
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                    <form action="{{ route('cash-transactions.destroy', $transaction->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger">حذف</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection