@extends('layouts.app')

@section('title', 'استيراد إيداعات')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">استيراد إيداعات من ملف إكسيل</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-deposits.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة إلى قائمة الإيداعات
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> تعليمات الاستيراد:</h5>
                        <ul>
                            <li>يجب أن يكون الملف بتنسيق Excel (.xlsx, .xls) أو CSV.</li>
                            <li>يجب أن يحتوي الملف على العناوين التالية في الصف الأول:
                                <ul>
                                    <li><code>cash_register</code> - اسم الخزينة أو المعرف (إلزامي)</li>
                                    <li><code>amount</code> - المبلغ (إلزامي)</li>
                                    <li><code>party_name</code> - اسم حساب الطرف أو المعرف (إلزامي)</li>
                                    <li><code>party_type</code> - نوع الطرف (customer, supplier, employee, other) (اختياري، الافتراضي: other)</li>
                                    <li><code>date</code> - التاريخ (اختياري، الافتراضي: التاريخ الحالي)</li>
                                    <li><code>elevator</code> - الرقم التسلسلي للمصعد أو المعرف (اختياري)</li>
                                    <li><code>notes</code> - ملاحظات (اختياري)</li>
                                </ul>
                            </li>
                            <li>سيتم إنشاء قيد محاسبي تلقائي لكل إيداع مستورد.</li>
                        </ul>
                    </div>

                    <form action="{{ route('cash-deposits.import') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="import_file">اختر ملف الإكسيل</label>
                            <input type="file" name="import_file" id="import_file" class="form-control @error('import_file') is-invalid @enderror" required>
                            @error('import_file')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-file-import"></i> بدء الاستيراد
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
