@extends('layouts.app')

@section('title', 'إضافة سحب جديد')

@push('styles')
<style>
    /* تنسيقات Select2 للدعم العربي */
    .select2-container--default .select2-selection--single {
        height: 38px;
        border: 1px solid #ced4da;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 38px;
        padding-right: 12px;
        padding-left: 20px;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px;
    }
    .select2-container--default .select2-results__option {
        padding: 8px 12px;
    }
    .select2-container--default .select2-search--dropdown .select2-search__field {
        border: 1px solid #ced4da;
        border-radius: 4px;
        padding: 6px 12px;
        direction: rtl;
    }
    .select2-dropdown {
        border: 1px solid #ced4da;
        border-radius: 4px;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة سحب جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-withdrawals.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('cash-transactions.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="type" value="withdrawal">

                        <div class="form-group">
                            <label for="cash_register_id">الخزينة <span class="text-danger">*</span></label>
                            <select name="cash_register_id" id="cash_register_id" class="form-control @error('cash_register_id') is-invalid @enderror" required>
                                <option value="">اختر الخزينة</option>
                                @foreach($cashRegisters as $register)
                                    <option value="{{ $register->id }}" {{ old('cash_register_id') == $register->id ? 'selected' : '' }}>
                                        {{ $register->name }} ({{ number_format($register->current_balance, 2) }} {{ $register->currency }})
                                    </option>
                                @endforeach
                            </select>
                            @error('cash_register_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="amount">مبلغ السحب <span class="text-danger">*</span></label>
                            <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" step="0.01" min="0.01" required>
                            @error('amount')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                            <small class="text-muted" id="max_amount_info">يرجى اختيار الخزينة أولاً لمعرفة الحد الأقصى للسحب</small>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_name">الطرف المدين <span class="text-danger">*</span></label>
                                    <select name="party_name" id="party_name" class="form-control select2 @error('party_name') is-invalid @enderror" required>
                                        <option value="">اختر الحساب</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ old('party_name') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_code }} - {{ $account->name }} ({{ number_format($account->current_balance, 2) }} {{ $account->currency }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('party_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_type">نوع الطرف <span class="text-danger">*</span></label>
                                    <select name="party_type" id="party_type" class="form-control @error('party_type') is-invalid @enderror" required>
                                        <option value="">اختر نوع الطرف</option>
                                        <option value="customer" {{ old('party_type') == 'customer' ? 'selected' : '' }}>عميل</option>
                                        <option value="supplier" {{ old('party_type') == 'supplier' ? 'selected' : '' }}>مورد</option>
                                        <option value="employee" {{ old('party_type') == 'employee' ? 'selected' : '' }}>موظف</option>
                                        <option value="other" {{ old('party_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('party_type')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="withdrawal_date">تاريخ الصرف <span class="text-danger">*</span></label>
                            <input type="date" name="withdrawal_date" id="withdrawal_date" class="form-control @error('withdrawal_date') is-invalid @enderror" value="{{ old('withdrawal_date', date('Y-m-d')) }}" required>
                            @error('withdrawal_date')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="attachment">مرفق</label>
                            <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                            <small class="text-muted">يمكنك إرفاق ملف (صورة أو PDF) بحجم أقصى 2 ميجابايت</small>
                            @error('attachment')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-minus-circle"></i> سحب
                            </button>
                            <a href="{{ route('cash-withdrawals.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // تهيئة Select2 للبحث في الحسابات
        $('.select2').select2({
            placeholder: "اختر الحساب",
            allowClear: true,
            width: '100%',
            language: {
                noResults: function() {
                    return "لا توجد نتائج";
                },
                searching: function() {
                    return "جاري البحث...";
                }
            }
        });
        
        // تحديث الحد الأقصى للسحب عند تغيير الخزينة
        $('#cash_register_id').change(function() {
            var selectedOption = $(this).find('option:selected');
            if (selectedOption.val()) {
                var balanceText = selectedOption.text().match(/\((.*?)\)/)[1];
                $('#max_amount_info').text('الحد الأقصى للسحب هو ' + balanceText);
                
                // استخراج الرصيد كرقم
                var balance = parseFloat(balanceText.replace(/[^0-9.-]+/g, ''));
                $('#amount').attr('max', balance);
            } else {
                $('#max_amount_info').text('يرجى اختيار الخزينة أولاً لمعرفة الحد الأقصى للسحب');
                $('#amount').removeAttr('max');
            }
        });
        
        // تنفيذ التغيير عند تحميل الصفحة إذا كان هناك قيمة محددة مسبقًا
        if ($('#cash_register_id').val()) {
            $('#cash_register_id').trigger('change');
        }
    });
</script>
@endpush
@endsection