@extends('layouts.app')

@section('title', 'إضافة إيداع جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة إيداع جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-deposits.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <!-- رسائل تحذير للمساعدة في تشخيص المشكلة -->
                    <div class="alert alert-warning">
                        <h5><i class="icon fas fa-exclamation-triangle"></i> تحقق من الآتي قبل إنشاء الإيداع:</h5>
                        <ul>
                            <li>تأكد من وجود <strong>سنة مالية نشطة</strong> وغير مغلقة</li>
                            <li>تأكد من وجود <strong>فترة محاسبية نشطة</strong> تشمل تاريخ اليوم</li>
                            <li>تأكد من أن <strong>الخزينة مرتبطة بحساب</strong> في دليل الحسابات</li>
                            <li>تأكد من أن <strong>الحساب المختار للطرف الدائن نشط</strong> في دليل الحسابات</li>
                        </ul>
                    </div>

                    <form action="{{ route('cash-transactions.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="type" value="deposit">

                        <div class="form-group">
                            <label for="cash_register_id">الخزينة <span class="text-danger">*</span></label>
                            <select name="cash_register_id" id="cash_register_id" class="form-control @error('cash_register_id') is-invalid @enderror" required>
                                <option value="">اختر الخزينة</option>
                                @foreach($cashRegisters as $register)
                                    <option value="{{ $register->id }}" {{ old('cash_register_id') == $register->id ? 'selected' : '' }}>
                                        {{ $register->name }} ({{ number_format($register->current_balance, 2) }} {{ $register->currency }})
                                    </option>
                                @endforeach
                            </select>
                            @error('cash_register_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">مبلغ الإيداع <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" step="0.01" min="0.01" required>
                                    @error('amount')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="receipt_date">تاريخ الاستلام <span class="text-danger">*</span></label>
                                    <input type="date" name="receipt_date" id="receipt_date" class="form-control @error('receipt_date') is-invalid @enderror" value="{{ old('receipt_date', date('Y-m-d')) }}" required>
                                    @error('receipt_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_name">الطرف الدائن <span class="text-danger">*</span></label>
                                    <select name="party_name" id="party_name" class="form-control @error('party_name') is-invalid @enderror" required>
                                        <option value="">اختر الحساب</option>
                                        @foreach($accounts as $account)
                                            <option value="{{ $account->id }}" {{ old('party_name') == $account->id ? 'selected' : '' }}>
                                                {{ $account->account_code }} - {{ $account->name }} ({{ number_format($account->current_balance, 2) }} {{ $account->currency }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('party_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_type">نوع الطرف <span class="text-danger">*</span></label>
                                    <select name="party_type" id="party_type" class="form-control @error('party_type') is-invalid @enderror" required>
                                        <option value="">اختر نوع الطرف</option>
                                        <option value="customer" {{ old('party_type') == 'customer' ? 'selected' : '' }}>عميل</option>
                                        <option value="supplier" {{ old('party_type') == 'supplier' ? 'selected' : '' }}>مورد</option>
                                        <option value="employee" {{ old('party_type') == 'employee' ? 'selected' : '' }}>موظف</option>
                                        <option value="other" {{ old('party_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('party_type')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="elevator_id">المصعد (اختياري)</label>
                            <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror">
                                <option value="">-- اختر المصعد --</option>
                                @foreach($elevators as $elevator)
                                    <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                        {{ $elevator->serial_number }} - {{ $elevator->model }} ({{ $elevator->customer->name }})
                                    </option>
                                @endforeach
                            </select>
                            <small class="text-muted">يمكنك ربط هذا الإيداع بمصعد محدد لتسهيل المتابعة</small>
                            @error('elevator_id')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="attachment">مرفق</label>
                            <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                            <small class="text-muted">يمكنك إرفاق ملف (صورة أو PDF) بحجم أقصى 2 ميجابايت</small>
                            @error('attachment')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-plus-circle"></i> إيداع
                            </button>
                            <a href="{{ route('cash-deposits.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection