@extends('layouts.app')

@section('title', 'إضافة معاملة جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة معاملة جديدة</h3>
                    <div class="card-tools">
                        <a href="{{ route('cash-transactions.index') }}" class="btn btn-default btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('cash-transactions.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cash_register_id">الخزينة <span class="text-danger">*</span></label>
                                    <select name="cash_register_id" id="cash_register_id" class="form-control @error('cash_register_id') is-invalid @enderror" required>
                                        <option value="">اختر الخزينة</option>
                                        @foreach($cashRegisters as $register)
                                            <option value="{{ $register->id }}" {{ old('cash_register_id') == $register->id ? 'selected' : '' }}>
                                                {{ $register->name }} ({{ number_format($register->current_balance, 2) }} {{ $register->currency }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('cash_register_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type">نوع المعاملة <span class="text-danger">*</span></label>
                                    <select name="type" id="type" class="form-control @error('type') is-invalid @enderror" required>
                                        <option value="">اختر نوع المعاملة</option>
                                        <option value="deposit" {{ old('type') == 'deposit' ? 'selected' : '' }}>إيداع</option>
                                        <option value="withdrawal" {{ old('type') == 'withdrawal' ? 'selected' : '' }}>سحب</option>
                                        <option value="transfer" {{ old('type') == 'transfer' ? 'selected' : '' }}>تحويل</option>
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">المبلغ <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" id="amount" class="form-control @error('amount') is-invalid @enderror" value="{{ old('amount') }}" step="0.01" min="0.01" required>
                                    @error('amount')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6" id="related_cash_register_container" style="display: none;">
                                <div class="form-group">
                                    <label for="related_cash_register_id">الخزينة المستلمة <span class="text-danger">*</span></label>
                                    <select name="related_cash_register_id" id="related_cash_register_id" class="form-control @error('related_cash_register_id') is-invalid @enderror">
                                        <option value="">اختر الخزينة المستلمة</option>
                                        @foreach($cashRegisters as $register)
                                            <option value="{{ $register->id }}" {{ old('related_cash_register_id') == $register->id ? 'selected' : '' }}>
                                                {{ $register->name }} ({{ number_format($register->current_balance, 2) }} {{ $register->currency }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('related_cash_register_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row" id="party_info_container" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_name">اسم الطرف <span class="text-danger">*</span></label>
                                    <input type="text" name="party_name" id="party_name" class="form-control @error('party_name') is-invalid @enderror" value="{{ old('party_name') }}">
                                    @error('party_name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="party_type">نوع الطرف <span class="text-danger">*</span></label>
                                    <select name="party_type" id="party_type" class="form-control @error('party_type') is-invalid @enderror">
                                        <option value="">اختر نوع الطرف</option>
                                        <option value="customer" {{ old('party_type') == 'customer' ? 'selected' : '' }}>عميل</option>
                                        <option value="supplier" {{ old('party_type') == 'supplier' ? 'selected' : '' }}>مورد</option>
                                        <option value="employee" {{ old('party_type') == 'employee' ? 'selected' : '' }}>موظف</option>
                                        <option value="other" {{ old('party_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                    @error('party_type')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="attachment">مرفق</label>
                                    <input type="file" name="attachment" id="attachment" class="form-control-file @error('attachment') is-invalid @enderror">
                                    <small class="text-muted">يمكنك إرفاق ملف (صورة أو PDF) بحجم أقصى 2 ميجابايت</small>
                                    @error('attachment')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ
                                </button>
                                <a href="{{ route('cash-transactions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // عرض/إخفاء حقول حسب نوع المعاملة
        $('#type').change(function() {
            var type = $(this).val();
            
            // إدارة حقل الخزينة المستلمة (للتحويل)
            if (type === 'transfer') {
                $('#related_cash_register_container').show();
                $('#related_cash_register_id').prop('required', true);
                $('#party_info_container').hide();
                $('#party_name, #party_type').prop('required', false);
            } else {
                $('#related_cash_register_container').hide();
                $('#related_cash_register_id').prop('required', false);
            }
            
            // إدارة حقول معلومات الطرف (للإيداع والسحب)
            if (type === 'deposit' || type === 'withdrawal') {
                $('#party_info_container').show();
                $('#party_name, #party_type').prop('required', true);
            } else {
                $('#party_info_container').hide();
                $('#party_name, #party_type').prop('required', false);
            }
        });

        // تنفيذ التغيير عند تحميل الصفحة إذا كان هناك قيمة محددة مسبقًا
        var initialType = $('#type').val();
        if (initialType === 'transfer') {
            $('#related_cash_register_container').show();
            $('#related_cash_register_id').prop('required', true);
        } else if (initialType === 'deposit' || initialType === 'withdrawal') {
            $('#party_info_container').show();
            $('#party_name, #party_type').prop('required', true);
        }

        // منع اختيار نفس الخزينة للتحويل
        $('#cash_register_id').change(function() {
            var selectedId = $(this).val();
            $('#related_cash_register_id option').show();
            $('#related_cash_register_id option[value="' + selectedId + '"]').hide();
        });
        
        // تنفيذ التحديث عند تحميل الصفحة
        var initialCashRegisterId = $('#cash_register_id').val();
        if (initialCashRegisterId) {
            $('#related_cash_register_id option').show();
            $('#related_cash_register_id option[value="' + initialCashRegisterId + '"]').hide();
        }
    });
</script>
@endpush
@endsection