@extends('layouts.app')

@section('title', 'تقرير ملخص الخزائن')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير ملخص الخزائن</h4>
                    <div>
                        <a href="{{ route('cash-reports.index') }}" class="btn btn-secondary">العودة للتقارير</a>
                        <button type="button" class="btn btn-success" onclick="window.print()">طباعة</button>
                        <form action="{{ route('cash-reports.export-excel') }}" method="POST" class="d-inline">
                            @csrf
                            <input type="hidden" name="report_type" value="registers_summary">
                            <button type="submit" class="btn btn-primary">تصدير Excel</button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>اسم الخزينة</th>
                                    <th>الرمز</th>
                                    <th>المسؤول</th>
                                    <th>الرصيد الأولي</th>
                                    <th>إجمالي الإيداعات</th>
                                    <th>إجمالي المسحوبات</th>
                                    <th>التحويلات الصادرة</th>
                                    <th>التحويلات الواردة</th>
                                    <th>الرصيد الحالي</th>
                                    <th>العملة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $totalBalance = 0; @endphp
                                @forelse($cashRegisters as $index => $register)
                                @php
                                    $currentBalance = $register->initial_balance + $register->total_deposits - $register->total_withdrawals - $register->total_transfers_out + $register->total_transfers_in;
                                    $totalBalance += $currentBalance;
                                @endphp
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $register->name }}</td>
                                    <td>{{ $register->code }}</td>
                                    <td>{{ $register->responsibleUser ? $register->responsibleUser->name : '-' }}</td>
                                    <td class="text-nowrap">{{ number_format($register->initial_balance, 2) }}</td>
                                    <td class="text-nowrap">{{ number_format($register->total_deposits, 2) }}</td>
                                    <td class="text-nowrap">{{ number_format($register->total_withdrawals, 2) }}</td>
                                    <td class="text-nowrap">{{ number_format($register->total_transfers_out, 2) }}</td>
                                    <td class="text-nowrap">{{ number_format($register->total_transfers_in, 2) }}</td>
                                    <td class="text-nowrap font-weight-bold">{{ number_format($currentBalance, 2) }}</td>
                                    <td>{{ $register->currency }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="11" class="text-center">لا توجد خزائن مسجلة</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <td colspan="9" class="text-end">إجمالي الأرصدة</td>
                                    <td class="text-nowrap">{{ number_format($totalBalance, 2) }}</td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, nav, footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .container-fluid {
            width: 100%;
            padding: 0;
            margin: 0;
        }
    }
</style>
@endsection