@extends('layouts.app')

@section('title', 'تقارير الخزينة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>تقارير الخزينة</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير الحركة اليومية</h5>
                                    <p class="card-text">عرض جميع معاملات الخزينة ليوم محدد مع تفاصيل كل معاملة.</p>
                                    <form action="{{ route('cash-reports.daily-movement') }}" method="GET">
                                        <div class="form-group mb-3">
                                            <label for="date">التاريخ</label>
                                            <input type="date" class="form-control" id="date" name="date" value="{{ date('Y-m-d') }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="cash_register_id">الخزينة</label>
                                            <select class="form-control" id="cash_register_id" name="cash_register_id">
                                                <option value="">جميع الخزائن</option>
                                                @foreach($cashRegisters as $register)
                                                    <option value="{{ $register->id }}">{{ $register->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير ملخص الخزائن</h5>
                                    <p class="card-text">عرض ملخص لجميع الخزائن مع أرصدتها الحالية وإجمالي المعاملات.</p>
                                    <a href="{{ route('cash-reports.registers-summary') }}" class="btn btn-primary">عرض التقرير</a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير المعاملات حسب الفترة</h5>
                                    <p class="card-text">عرض معاملات الخزينة خلال فترة زمنية محددة مع إمكانية التصفية حسب نوع المعاملة.</p>
                                    <form action="{{ route('cash-reports.transactions-by-period') }}" method="GET">
                                        <div class="form-group mb-3">
                                            <label for="start_date">من تاريخ</label>
                                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ date('Y-m-01') }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="end_date">إلى تاريخ</label>
                                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ date('Y-m-d') }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="cash_register_id">الخزينة</label>
                                            <select class="form-control" id="cash_register_id" name="cash_register_id">
                                                <option value="">جميع الخزائن</option>
                                                @foreach($cashRegisters as $register)
                                                    <option value="{{ $register->id }}">{{ $register->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="type">نوع المعاملة</label>
                                            <select class="form-control" id="type" name="type">
                                                <option value="">جميع المعاملات</option>
                                                <option value="deposit">إيداع</option>
                                                <option value="withdrawal">سحب</option>
                                                <option value="transfer">تحويل</option>
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير الرصيد اليومي</h5>
                                    <p class="card-text">عرض تطور رصيد الخزائن يومياً خلال فترة زمنية محددة.</p>
                                    <form action="{{ route('cash-reports.daily-balance') }}" method="GET">
                                        <div class="form-group mb-3">
                                            <label for="start_date">من تاريخ</label>
                                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ date('Y-m-d', strtotime('-30 days')) }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="end_date">إلى تاريخ</label>
                                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ date('Y-m-d') }}">
                                        </div>
                                        <div class="form-group mb-3">
                                            <label for="cash_register_id">الخزينة</label>
                                            <select class="form-control" id="cash_register_id" name="cash_register_id">
                                                <option value="">جميع الخزائن</option>
                                                @foreach($cashRegisters as $register)
                                                    <option value="{{ $register->id }}">{{ $register->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection