@extends('layouts.app')

@section('title', 'تقرير الحركة اليومية للخزينة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير الحركة اليومية للخزينة - {{ $date }}</h4>
                    <div>
                        <a href="{{ route('cash-reports.index') }}" class="btn btn-secondary">العودة للتقارير</a>
                        <button type="button" class="btn btn-success" onclick="window.print()">طباعة</button>
                        <form action="{{ route('cash-reports.export-excel') }}" method="POST" class="d-inline">
                            @csrf
                            <input type="hidden" name="report_type" value="daily_movement">
                            <input type="hidden" name="date" value="{{ $date }}">
                            <input type="hidden" name="cash_register_id" value="{{ $selectedRegister ? $selectedRegister->id : '' }}">
                            <button type="submit" class="btn btn-primary">تصدير Excel</button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('cash-reports.daily-movement') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">التاريخ</label>
                                    <input type="date" class="form-control" id="date" name="date" value="{{ $date }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="cash_register_id">الخزينة</label>
                                    <select class="form-control" id="cash_register_id" name="cash_register_id">
                                        <option value="">جميع الخزائن</option>
                                        @foreach($cashRegisters as $register)
                                            <option value="{{ $register->id }}" {{ $selectedRegister && $selectedRegister->id == $register->id ? 'selected' : '' }}>
                                                {{ $register->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تحديث</button>
                            </div>
                        </div>
                    </form>

                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-success text-white">
                                <div class="card-body">
                                    <h5 class="card-title">إجمالي الإيداعات</h5>
                                    <h3 class="card-text">{{ number_format($totals['deposits'], 2) }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-danger text-white">
                                <div class="card-body">
                                    <h5 class="card-title">إجمالي المسحوبات</h5>
                                    <h3 class="card-text">{{ number_format($totals['withdrawals'], 2) }}</h3>
                                </div>
                            </div>
                        </div>
                        @if($selectedRegister)
                        <div class="col-md-3">
                            <div class="card bg-warning text-dark">
                                <div class="card-body">
                                    <h5 class="card-title">التحويلات الصادرة</h5>
                                    <h3 class="card-text">{{ number_format($totals['transfers_out'], 2) }}</h3>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h5 class="card-title">التحويلات الواردة</h5>
                                    <h3 class="card-text">{{ number_format($totals['transfers_in'], 2) }}</h3>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>الوقت</th>
                                    <th>نوع المعاملة</th>
                                    <th>الخزينة</th>
                                    <th>الخزينة المرتبطة</th>
                                    <th>المبلغ</th>
                                    <th>الوصف</th>
                                    <th>المستخدم</th>
                                    <th>المرجع</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($transactions as $index => $transaction)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $transaction->created_at->format('H:i:s') }}</td>
                                    <td>
                                        @if($transaction->type == 'deposit')
                                            <span class="badge bg-success">إيداع</span>
                                        @elseif($transaction->type == 'withdrawal')
                                            <span class="badge bg-danger">سحب</span>
                                        @elseif($transaction->type == 'transfer')
                                            <span class="badge bg-primary">تحويل</span>
                                        @endif
                                    </td>
                                    <td>{{ $transaction->cashRegister->name }}</td>
                                    <td>{{ $transaction->relatedCashRegister ? $transaction->relatedCashRegister->name : '-' }}</td>
                                    <td class="text-nowrap">{{ number_format($transaction->amount, 2) }}</td>
                                    <td>{{ $transaction->description }}</td>
                                    <td>{{ $transaction->user->name }}</td>
                                    <td>{{ $transaction->reference_number }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد معاملات لهذا اليوم</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .btn, form, .card-header, nav, footer {
            display: none !important;
        }
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        .card-body {
            padding: 0 !important;
        }
        body {
            margin: 0;
            padding: 0;
            background: #fff;
        }
        .container-fluid {
            width: 100%;
            padding: 0;
            margin: 0;
        }
    }
</style>
@endsection