@extends('layouts.app')

@section('title', 'تقرير الرصيد اليومي للخزائن')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
                    <h4 class="mb-0">تقرير الرصيد اليومي للخزائن ({{ $startDate }} - {{ $endDate }})</h4>
                    <div>
                        <a href="{{ route('cash-reports.index') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-arrow-right ml-1"></i> العودة للتقارير
                        </a>
                        <button type="button" class="btn btn-success btn-sm" onclick="window.print()">
                            <i class="fas fa-print ml-1"></i> طباعة
                        </button>
                        <form action="{{ route('cash-reports.export-excel') }}" method="POST" class="d-inline">
                            @csrf
                            <input type="hidden" name="report_type" value="daily_balance">
                            <input type="hidden" name="start_date" value="{{ $startDate }}">
                            <input type="hidden" name="end_date" value="{{ $endDate }}">
                            <input type="hidden" name="cash_register_id" value="{{ $cashRegisterId }}">
                            <button type="submit" class="btn btn-info btn-sm">
                                <i class="fas fa-file-excel ml-1"></i> تصدير Excel
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <!-- نموذج البحث -->
                    <div class="card mb-4 border-light">
                        <div class="card-header bg-light">
                            <h5 class="mb-0">معايير البحث</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('cash-reports.daily-balance') }}" method="GET">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="start_date">من تاريخ</label>
                                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="end_date">إلى تاريخ</label>
                                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="cash_register_id">الخزينة</label>
                                            <select class="form-control" id="cash_register_id" name="cash_register_id">
                                                <option value="">جميع الخزائن</option>
                                                @foreach($cashRegisters as $register)
                                                    <option value="{{ $register->id }}" {{ $cashRegisterId == $register->id ? 'selected' : '' }}>
                                                        {{ $register->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-1 d-flex align-items-end">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-search ml-1"></i> تحديث
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- طرق العرض -->
                    <div class="mb-4">
                        <ul class="nav nav-pills mb-3" id="viewOptions" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="summary-tab" data-toggle="pill" data-target="#summary-view" type="button" role="tab">
                                    <i class="fas fa-table ml-1"></i> ملخص الأرصدة
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="chart-tab" data-toggle="pill" data-target="#chart-view" type="button" role="tab">
                                    <i class="fas fa-chart-line ml-1"></i> الرسم البياني
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="details-tab" data-toggle="pill" data-target="#details-view" type="button" role="tab">
                                    <i class="fas fa-list ml-1"></i> التفاصيل اليومية
                                </button>
                            </li>
                        </ul>
                        
                        <div class="tab-content" id="viewOptionsContent">
                            <!-- عرض الملخص -->
                            <div class="tab-pane fade show active" id="summary-view" role="tabpanel">
                                <div class="row">
                                    @foreach($cashRegisters as $register)
                                    <div class="col-md-4 mb-4">
                                        <div class="card h-100 border-{{ $balanceData[$register->id]['balances'][end($dates)] < 0 ? 'danger' : 'success' }}">
                                            <div class="card-header bg-light">
                                                <h5 class="mb-0">{{ $register->name }}</h5>
                                            </div>
                                            <div class="card-body">
                                                <div class="text-center mb-4">
                                                    <h6 class="text-muted">الرصيد الحالي</h6>
                                                    <h3 class="{{ $balanceData[$register->id]['balances'][end($dates)] < 0 ? 'text-danger' : 'text-success' }}">
                                                        {{ number_format($balanceData[$register->id]['balances'][end($dates)], 2) }} {{ $register->currency }}
                                                    </h3>
                                                </div>
                                                
                                                <div class="row text-center">
                                                    <div class="col-6">
                                                        <div class="border-right">
                                                            <h6 class="text-muted">الرصيد الافتتاحي</h6>
                                                            <p class="mb-0 font-weight-bold">
                                                                {{ number_format($balanceData[$register->id]['balances'][$dates[0]], 2) }} {{ $register->currency }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <h6 class="text-muted">التغيير</h6>
                                                        @php
                                                            $change = $balanceData[$register->id]['balances'][end($dates)] - $balanceData[$register->id]['balances'][$dates[0]];
                                                        @endphp
                                                        <p class="mb-0 font-weight-bold {{ $change < 0 ? 'text-danger' : 'text-success' }}">
                                                            {{ $change > 0 ? '+' : '' }}{{ number_format($change, 2) }}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card-footer bg-light">
                                                <button class="btn btn-sm btn-outline-primary btn-block" 
                                                        onclick="showRegisterDetails('{{ $register->id }}', '{{ $register->name }}')">
                                                    <i class="fas fa-search ml-1"></i> عرض التفاصيل
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            
                            <!-- عرض الرسم البياني -->
                            <div class="tab-pane fade" id="chart-view" role="tabpanel">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="chart-container" style="position: relative; height:400px;">
                                            <canvas id="balanceChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- عرض التفاصيل اليومية -->
                            <div class="tab-pane fade" id="details-view" role="tabpanel">
                                <div class="card">
                                    <div class="card-body p-0">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-hover" id="balanceTable">
                                                <thead class="thead-dark">
                                                    <tr>
                                                        <th class="text-center" style="width: 200px;">التاريخ</th>
                                                        @foreach($cashRegisters as $register)
                                                            <th class="text-center">{{ $register->name }}</th>
                                                        @endforeach
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($dates as $date)
                                                        <tr>
                                                            <td class="text-center font-weight-bold">{{ date('Y-m-d', strtotime($date)) }}</td>
                                                            @foreach($cashRegisters as $register)
                                                                <td class="text-center">
                                                                    <span class="{{ $balanceData[$register->id]['balances'][$date] < 0 ? 'text-danger' : '' }} font-weight-bold">
                                                                        {{ number_format($balanceData[$register->id]['balances'][$date], 2) }} {{ $register->currency }}
                                                                    </span>
                                                                </td>
                                                            @endforeach
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal لعرض تفاصيل الخزينة -->
<div class="modal fade" id="registerDetailsModal" tabindex="-1" aria-labelledby="registerDetailsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="registerDetailsModalLabel">تفاصيل الخزينة</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="registerDetailsTable">
                        <thead class="thead-light">
                            <tr>
                                <th>التاريخ</th>
                                <th>الرصيد</th>
                                <th>التغيير اليومي</th>
                            </tr>
                        </thead>
                        <tbody id="registerDetailsBody">
                            <!-- سيتم ملء هذا الجزء بواسطة JavaScript -->
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تهيئة جدول البيانات
        if ($.fn.DataTable) {
            $('#balanceTable').DataTable({
                "paging": false,
                "searching": false,
                "info": false,
                "ordering": false,
                "responsive": true,
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
                }
            });
        }
        
        // إعداد الرسم البياني
        const ctx = document.getElementById('balanceChart');
        
        if (ctx) {
            // بيانات الخزائن والأرصدة
            const registerData = {
                @foreach($cashRegisters as $register)
                '{{ $register->id }}': {
                    name: '{{ $register->name }}',
                    currency: '{{ $register->currency }}',
                    balances: {
                        @foreach($dates as $date)
                            '{{ $date }}': {{ $balanceData[$register->id]['balances'][$date] }},
                        @endforeach
                    }
                },
                @endforeach
            };
            
            // تحديد التواريخ المختصرة للعرض في الرسم البياني
            const shortLabels = [
                @foreach($dates as $date)
                    '{{ date('m-d', strtotime($date)) }}',
                @endforeach
            ];
            
            // تحديد التواريخ الكاملة للعرض عند التحويم
            const fullLabels = [
                @foreach($dates as $date)
                    '{{ date('Y-m-d', strtotime($date)) }}',
                @endforeach
            ];
            
            const chartData = {
                labels: shortLabels,
                datasets: [
                    @foreach($cashRegisters as $index => $register)
                    {
                        label: '{{ $register->name }}',
                        data: [
                            @foreach($dates as $date)
                                {{ $balanceData[$register->id]['balances'][$date] }},
                            @endforeach
                        ],
                        borderColor: getChartColor({{ $index }}),
                        backgroundColor: getChartColor({{ $index }}, 0.1),
                        borderWidth: 2,
                        fill: false,
                        tension: 0.1,
                        pointRadius: 3,
                        pointHoverRadius: 5
                    },
                    @endforeach
                ]
            };

            new Chart(ctx, {
                type: 'line',
                data: chartData,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    interaction: {
                        mode: 'index',
                        intersect: false,
                    },
                    plugins: {
                        tooltip: {
                            callbacks: {
                                title: function(context) {
                                    return fullLabels[context[0].dataIndex];
                                },
                                label: function(context) {
                                    return context.dataset.label + ': ' + 
                                           new Intl.NumberFormat('ar-SA', { 
                                               style: 'decimal', 
                                               minimumFractionDigits: 2,
                                               maximumFractionDigits: 2 
                                           }).format(context.raw);
                                }
                            }
                        },
                        legend: {
                            position: 'top',
                            labels: {
                                padding: 20,
                                boxWidth: 15,
                                usePointStyle: true,
                                pointStyle: 'circle'
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: false,
                            grid: {
                                drawBorder: false
                            },
                            ticks: {
                                callback: function(value) {
                                    return new Intl.NumberFormat('ar-SA', { 
                                        style: 'decimal', 
                                        minimumFractionDigits: 0,
                                        maximumFractionDigits: 0 
                                    }).format(value);
                                }
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            }
                        }
                    }
                }
            });
            
            // تخزين بيانات الخزائن للاستخدام في النافذة المنبثقة
            window.registerData = registerData;
            window.fullDates = fullLabels;
        }
        
        // تبديل طرق العرض
        $('#viewOptions button').on('click', function (e) {
            e.preventDefault();
            $(this).tab('show');
        });
    });
    
    // دالة لعرض تفاصيل الخزينة في النافذة المنبثقة
    function showRegisterDetails(registerId, registerName) {
        if (!window.registerData || !window.registerData[registerId]) {
            return;
        }
        
        const register = window.registerData[registerId];
        const dates = window.fullDates;
        const balances = register.balances;
        
        // تحديث عنوان النافذة المنبثقة
        $('#registerDetailsModalLabel').text('تفاصيل خزينة: ' + registerName);
        
        // إنشاء صفوف الجدول
        let tableRows = '';
        let prevBalance = null;
        
        for (let i = 0; i < dates.length; i++) {
            const date = dates[i];
            const balance = balances[date];
            let change = 0;
            let changeClass = '';
            let changePrefix = '';
            
            if (prevBalance !== null) {
                change = balance - prevBalance;
                changeClass = change < 0 ? 'text-danger' : (change > 0 ? 'text-success' : '');
                changePrefix = change > 0 ? '+' : '';
            }
            
            tableRows += `
                <tr>
                    <td>${date}</td>
                    <td class="${balance < 0 ? 'text-danger' : ''} font-weight-bold">
                        ${new Intl.NumberFormat('ar-SA', { 
                            style: 'decimal', 
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2 
                        }).format(balance)} ${register.currency}
                    </td>
                    <td class="${changeClass}">
                        ${i === 0 ? '-' : changePrefix + new Intl.NumberFormat('ar-SA', { 
                            style: 'decimal', 
                            minimumFractionDigits: 2,
                            maximumFractionDigits: 2 
                        }).format(change)}
                    </td>
                </tr>
            `;
            
            prevBalance = balance;
        }
        
        // تحديث محتوى الجدول
        $('#registerDetailsBody').html(tableRows);
        
        // عرض النافذة المنبثقة
        $('#registerDetailsModal').modal('show');
    }
    
    // دالة للحصول على لون للرسم البياني
    function getChartColor(index, alpha = 1) {
        const colors = [
            `rgba(54, 162, 235, ${alpha})`,   // أزرق
            `rgba(255, 99, 132, ${alpha})`,   // أحمر
            `rgba(75, 192, 192, ${alpha})`,   // أخضر فاتح
            `rgba(255, 159, 64, ${alpha})`,   // برتقالي
            `rgba(153, 102, 255, ${alpha})`,  // بنفسجي
            `rgba(255, 206, 86, ${alpha})`,   // أصفر
            `rgba(22, 160, 133, ${alpha})`,   // أخضر غامق
            `rgba(211, 84, 0, ${alpha})`,     // برتقالي غامق
            `rgba(46, 64, 83, ${alpha})`,     // أزرق غامق
            `rgba(192, 57, 43, ${alpha})`,    // أحمر غامق
            `rgba(155, 89, 182, ${alpha})`,   // بنفسجي فاتح
            `rgba(52, 152, 219, ${alpha})`,   // أزرق فاتح
        ];
        
        return colors[index % colors.length];
    }
</script>
@endsection

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4/css/dataTables.bootstrap4.min.css">
<style>
    /* تنسيقات عامة */
    .card {
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        margin-bottom: 20px;
    }
    
    .card-header {
        border-radius: 8px 8px 0 0 !important;
        padding: 12px 20px;
    }
    
    .card-body {
        padding: 20px;
    }
    
    /* تنسيق البطاقات في الملخص */
    #summary-view .card {
        transition: all 0.3s ease;
    }
    
    #summary-view .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }
    
    #summary-view .card-header {
        border-bottom: none;
    }
    
    #summary-view .card-footer {
        background-color: transparent;
        border-top: 1px solid rgba(0, 0, 0, 0.05);
    }
    
    /* تنسيق التبويبات */
    .nav-pills {
        margin-bottom: 20px;
    }
    
    .nav-pills .nav-link {
        border-radius: 20px;
        padding: 8px 20px;
        margin-right: 10px;
        font-weight: 600;
        color: #495057;
        background-color: #f8f9fa;
    }
    
    .nav-pills .nav-link.active {
        background-color: #007bff;
        color: white;
    }
    
    /* تنسيق الجداول */
    .table th {
        font-weight: 600;
        background-color: #f8f9fa;
    }
    
    .table-hover tbody tr:hover {
        background-color: rgba(0, 123, 255, 0.05);
    }
    
    /* تنسيق الرسم البياني */
    .chart-container {
        margin: 20px 0;
        border-radius: 8px;
        background-color: white;
        padding: 15px;
    }
    
    /* تنسيق النافذة المنبثقة */
    .modal-content {
        border-radius: 8px;
        border: none;
    }
    
    .modal-header {
        border-radius: 8px 8px 0 0;
    }
    
    /* تنسيق الطباعة */
    @media print {
        body {
            background-color: white;
            margin: 0;
            padding: 0;
        }
        
        .container-fluid {
            width: 100%;
            padding: 0;
            margin: 0;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .card-header, .card-footer, .btn, form, nav, footer, .nav-pills, .modal {
            display: none !important;
        }
        
        /* إظهار محتوى التبويب النشط فقط */
        .tab-content > .tab-pane {
            display: none !important;
        }
        
        .tab-content > .active {
            display: block !important;
        }
        
        /* تنسيق الجداول للطباعة */
        .table {
            width: 100% !important;
            border-collapse: collapse !important;
        }
        
        .table th, .table td {
            padding: 5px !important;
            border: 1px solid #ddd !important;
        }
        
        /* تنسيق الرسم البياني للطباعة */
        #chart-view {
            page-break-before: always;
        }
        
        .chart-container {
            height: 400px !important;
            width: 100% !important;
        }
        
        /* إضافة عنوان الصفحة عند الطباعة */
        #summary-view::before {
            content: "تقرير الرصيد اليومي للخزائن";
            display: block;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 20px;
        }
    }
    
    /* تنسيقات للشاشات الصغيرة */
    @media (max-width: 768px) {
        .nav-pills .nav-link {
            padding: 6px 12px;
            font-size: 14px;
        }
        
        #summary-view .card {
            margin-bottom: 15px;
        }
    }
</style>
@endsection